/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.BeakerXClasspath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagic;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.scala.magic.command.EnableSparkSupportActionOptions;
import com.twosigma.beakerx.scala.magic.command.EnableSparkSupportOptions;
import com.twosigma.beakerx.scala.magic.command.LoadLatestVersionOfSparkIfIsNotOnClasspath;
import com.twosigma.beakerx.scala.magic.command.LoadSparkFrom_SPARK_HOME_Command;
import com.twosigma.beakerx.scala.magic.command.RunOptionsCommand;
import com.twosigma.beakerx.scala.magic.command.SparkInitCommandFactory;
import com.twosigma.beakerx.scala.magic.command.SparkexJarService;
import com.twosigma.beakerx.util.BeakerXSystemImpl;
import java.util.List;
import java.util.Optional;

public class SparkInitCommandFactoryImpl
implements SparkInitCommandFactory {
    private KernelFunctionality kernel;
    private SparkexJarService sparkexJarService;
    private final EnableSparkSupportOptions enableSparkSupportOptions;
    private final EnableSparkSupportActionOptions supportActionOptions;

    public SparkInitCommandFactoryImpl(KernelFunctionality kernel, SparkexJarService sparkexJarService, EnableSparkSupportOptions enableSparkSupportOptions, EnableSparkSupportActionOptions supportActionOptions) {
        this.kernel = kernel;
        this.sparkexJarService = sparkexJarService;
        this.enableSparkSupportOptions = enableSparkSupportOptions;
        this.supportActionOptions = supportActionOptions;
    }

    @Override
    public SparkInitCommandFactory.Command addSparkexJar() {
        return new SparkInitCommandFactory.Command(){

            @Override
            public MagicCommandOutcomeItem run() {
                return SparkInitCommandFactoryImpl.this.sparkexJarService.addSparkexJar(SparkInitCommandFactoryImpl.this.kernel);
            }

            @Override
            public String getErrorMessage() {
                return "Cannot load sparkex.jar";
            }
        };
    }

    @Override
    public SparkInitCommandFactory.Command loadSparkSupportMagicClass() {
        return new SparkInitCommandFactory.Command(){

            @Override
            public MagicCommandOutcomeItem run() {
                Optional magic = CodeFactory.findMagicCommandFunctionality((List)SparkInitCommandFactoryImpl.this.kernel.getMagicCommandTypes(), (String)"%load_magic");
                MagicCommandOutcomeItem magicCommandOutcomeItem = ((LoadMagicMagicCommand)magic.get()).load("com.twosigma.beakerx.scala.magic.command.LoadSparkSupportMagicCommand");
                return magicCommandOutcomeItem;
            }

            @Override
            public String getErrorMessage() {
                return "Cannot load LoadSparkSupportMagicCommand class";
            }
        };
    }

    @Override
    public SparkInitCommandFactory.Command runOptions(MagicCommandExecutionParam param) {
        return new RunOptionsCommand(this.enableSparkSupportOptions, param.getCommand(), param.getCode().getMessage());
    }

    @Override
    public SparkInitCommandFactory.Command loadSparkFrom_SPARK_HOME_IfIsNotOnClasspath() {
        Optional magic = CodeFactory.findMagicCommandFunctionality((List)this.kernel.getMagicCommandTypes(), (String)"%classpath add jar");
        ClasspathAddJarMagicCommand classpathAddJarMagicCommand = (ClasspathAddJarMagicCommand)magic.get();
        return new LoadSparkFrom_SPARK_HOME_Command((ClasspathAddJarMagic)classpathAddJarMagicCommand, (BeakerXClasspath)this.kernel.getClasspath(), BeakerXSystemImpl.getINSTANCE());
    }

    @Override
    public SparkInitCommandFactory.Command loadLatestVersionOfSparkIfIsNotOnClasspath(MagicCommandExecutionParam param) {
        return new LoadLatestVersionOfSparkIfIsNotOnClasspath((BeakerXClasspath)this.kernel.getClasspath(), this.supportActionOptions, param.getCode().getMessage());
    }

    @Override
    public SparkInitCommandFactory.Command loadSparkSupportMagic(final MagicCommandExecutionParam param) {
        return new SparkInitCommandFactory.Command(){

            @Override
            public MagicCommandOutcomeItem run() {
                String loadSparkMagic = "%loadSparkSupport";
                Optional magic = CodeFactory.findMagicCommandFunctionality((List)SparkInitCommandFactoryImpl.this.kernel.getMagicCommandTypes(), (String)loadSparkMagic);
                MagicCommandOutcomeItem execute = ((MagicCommandFunctionality)magic.get()).execute(param);
                return execute;
            }

            @Override
            public String getErrorMessage() {
                return "Error loading Spark, was it added to the classpath?";
            }
        };
    }
}

