/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.msg.StacktraceHtmlPrinter;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Button;
import com.twosigma.beakerx.widget.Foldout;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.RESTButton;
import com.twosigma.beakerx.widget.SingleSparkSession;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkEngineWithUIImpl;
import com.twosigma.beakerx.widget.SparkFoldout;
import com.twosigma.beakerx.widget.SparkStateGroupPanel;
import com.twosigma.beakerx.widget.SparkStateProgress;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUIForm;
import com.twosigma.beakerx.widget.SparkUIStatus;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.SparkVariable;
import com.twosigma.beakerx.widget.Text;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import com.twosigma.beakerx.widget.configuration.SparkConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.SparkSession;

public class SparkUI
extends VBox
implements SparkUIApi {
    public static final String ONE_SPARK_SESSION_MSG_ERROR = "Cannot have more than one Spark session open in the same notebook.";
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    public static final String SPARK_MASTER_DEFAULT = "local[*]";
    private static final String SPARK_APP_ID = "sparkAppId";
    public static final String ERROR_CREATING_SPARK_SESSION = "Error creating SparkSession, see the console log for more explanation";
    public static final String SPARK_EXECUTOR_CORES_DEFAULT = "10";
    public static final String SPARK_EXECUTOR_MEMORY_DEFAULT = "8g";
    public static final Map<String, String> SPARK_ADVANCED_OPTIONS_DEFAULT = new HashMap<String, String>();
    public static final String PUT_SPARK_JOBS_IN_THE_BACKGROUND = "putSparkJobsInTheBackground";
    public static final String CANCELLED_SPARK_JOBS = "cancelledSparkJobs";
    private final SparkUIForm sparkUIForm;
    private HBox statusPanel;
    private Map<Integer, SparkStateGroupPanel> progressBarMap = new HashMap<Integer, SparkStateGroupPanel>();
    private SparkFoldout jobPanel = null;
    private Message currentParentHeader = null;
    private SparkEngineWithUI sparkEngine;
    private SparkUiDefaults sparkUiDefaults;
    private SingleSparkSession singleSparkSession;

    SparkUI(SparkSession.Builder builder, SparkEngineWithUIImpl.SparkEngineWithUIFactory sparkEngineFactory, SparkUiDefaults sparkUiDefaults, SingleSparkSession singleSparkSession) {
        super(new ArrayList());
        this.sparkUiDefaults = sparkUiDefaults;
        this.sparkUiDefaults.loadDefaults(builder);
        this.sparkEngine = sparkEngineFactory.create(builder);
        this.singleSparkSession = singleSparkSession;
        VBox sparkUIFormPanel = new VBox(new ArrayList());
        this.add((Widget)sparkUIFormPanel);
        SparkVariable.putSparkUI(this);
        this.sparkUIForm = new SparkUIForm(this.sparkEngine, sparkUiDefaults, this::initSparkContext);
        sparkUIFormPanel.add((Widget)this.sparkUIForm);
        this.configureRESTMapping();
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    @Override
    public void startSpinner(Message parentMessage) {
        this.sparkUIForm.startSpinner(parentMessage);
    }

    @Override
    public void stopSpinner() {
        this.sparkUIForm.stopSpinner();
    }

    private void initSparkContext(Message parentMessage) {
        this.sparkUIForm.clearErrors();
        KernelFunctionality kernel = KernelManager.get();
        if (this.singleSparkSession.isActive()) {
            this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)ONE_SPARK_SESSION_MSG_ERROR));
        } else {
            SparkVariable.putSparkUI(this);
            this.configureSparkContext(parentMessage, kernel);
        }
    }

    private void configureSparkContext(Message parentMessage, KernelFunctionality kernel) {
        try {
            this.sparkUIForm.setAllToDisabled();
            TryResult configure = this.sparkEngine.configure(kernel, this, parentMessage);
            if (configure.isError()) {
                this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)ERROR_CREATING_SPARK_SESSION));
                this.sparkUIForm.setAllToEnabled();
            } else {
                this.singleSparkSession.active();
                this.sparkUIForm.saveDefaults();
                this.sparkUIForm.getConnectButton().setDomClasses(Arrays.asList("hidden"));
                this.sparkUiDefaults.saveProfileName(this.sparkUIForm.getProfileName());
                this.applicationStart();
            }
        }
        catch (Exception e) {
            this.sparkUIForm.setAllToEnabled();
            this.sparkUIForm.sendError(StacktraceHtmlPrinter.printRedBold((String)e.getMessage()));
        }
    }

    private SparkSession getSparkSession() {
        return this.sparkEngine.getOrCreate();
    }

    private void applicationStart() {
        this.statusPanel = new SparkUIStatus(() -> this.getSparkSession().sparkContext().stop());
        this.sparkUIForm.setDomClasses(new ArrayList<String>(Arrays.asList("bx-disabled")));
        this.add(0, (Widget)this.statusPanel);
        this.sendUpdate(SPARK_APP_ID, this.sparkEngine.getSparkAppId());
        this.sendUpdate("sparkUiWebUrl", this.sparkEngine.getSparkUiWebUrl());
        this.sendUpdate("sparkMasterUrl", this.sparkEngine.getSparkMasterUrl());
    }

    @Override
    public void applicationEnd() {
        this.sparkUIForm.setDomClasses(new ArrayList());
        this.sparkUIForm.setAllToEnabled();
        this.removeStatusPanel();
        this.singleSparkSession.inActive();
    }

    private void removeStatusPanel() {
        if (this.statusPanel != null) {
            this.remove((Widget)this.statusPanel);
            this.statusPanel = null;
        }
    }

    @Override
    public void startStage(int stageId, int numTasks) {
        if (this.isStartStageFromNewCell()) {
            this.jobPanel = this.createSparkFoldout(this.jobPanel);
        }
        SparkStateProgress intProgress = new SparkStateProgress(numTasks, stageId, stageId, this.jobLink(stageId), this.stageLink(stageId));
        intProgress.init();
        Widget xButton = this.createCancelledJobsButton(stageId);
        Widget bkgButton = this.createBkgJobsButton(stageId);
        SparkStateGroupPanel sparkProgressDecorator = new SparkStateGroupPanel(intProgress, Arrays.asList(xButton, bkgButton));
        this.jobPanel.add((Widget)sparkProgressDecorator);
        this.progressBarMap.put(stageId, sparkProgressDecorator);
    }

    private Widget createBkgJobsButton(int stageId) {
        BeakerXServer beakerXServer = KernelManager.get().getBeakerXServer();
        RESTButton bkgButton = new RESTButton(beakerXServer.getURL() + PUT_SPARK_JOBS_IN_THE_BACKGROUND);
        bkgButton.setTooltip("put spark job in the background, let it complete asynchronously");
        bkgButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-bg")));
        return bkgButton;
    }

    private Widget createCancelledJobsButton(int stageId) {
        BeakerXServer beakerXServer = KernelManager.get().getBeakerXServer();
        RESTButton xButton = new RESTButton(beakerXServer.getURL() + CANCELLED_SPARK_JOBS + "/" + stageId);
        xButton.setTooltip("interrupt spark job");
        xButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        return xButton;
    }

    private boolean isStartStageFromNewCell() {
        return InternalVariable.getParentHeader() != this.currentParentHeader;
    }

    private SparkFoldout createSparkFoldout(SparkFoldout oldJobPanel) {
        this.currentParentHeader = InternalVariable.getParentHeader();
        if (oldJobPanel != null) {
            oldJobPanel.getLayout().setDisplayNone();
            oldJobPanel.close();
        }
        Foldout.FoldoutOption foldoutOption = new Foldout.FoldoutOption();
        foldoutOption.headerLabel = "Spark progress";
        SparkFoldout jobPanel = new SparkFoldout(new ArrayList(), foldoutOption);
        jobPanel.display();
        return jobPanel;
    }

    @Override
    public void endStage(int stageId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().hide();
    }

    @Override
    public void taskStart(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addActive();
    }

    @Override
    public void taskEnd(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addDone();
    }

    @Override
    public void taskCancelled(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addCancelled();
    }

    private String stageLink(int stageId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/stages/stage/?id=" + stageId + "&attempt=0";
        }
        return "";
    }

    private String jobLink(int jobId) {
        if (this.getSparkSession().sparkContext().uiWebUrl().isDefined()) {
            return (String)this.getSparkSession().sparkContext().uiWebUrl().get() + "/jobs/job/?id=" + jobId;
        }
        return "";
    }

    @Override
    public void cancelAllJobs() {
        this.getSparkSession().sparkContext().cancelAllJobs();
    }

    @Override
    public Text getMasterURL() {
        return this.sparkUIForm.getMasterURL();
    }

    @Override
    public boolean getHiveSupport() {
        return (Boolean)this.sparkUIForm.getHiveSupport().getValue();
    }

    @Override
    public Text getExecutorMemory() {
        return this.sparkUIForm.getExecutorMemory();
    }

    @Override
    public Text getExecutorCores() {
        return this.sparkUIForm.getExecutorCores();
    }

    @Override
    public List<SparkConfiguration.Configuration> getAdvancedOptions() {
        return this.sparkUIForm.getAdvancedOptions();
    }

    public Button getConnectButton() {
        return this.sparkUIForm.getConnectButton();
    }

    private void configureRESTMapping() {
        KernelFunctionality kernel = KernelManager.get();
        BeakerXServer beakerXServer = kernel.getBeakerXServer();
        beakerXServer.addPostMapping(PUT_SPARK_JOBS_IN_THE_BACKGROUND, ctx -> kernel.putEvaluationInToBackground());
        beakerXServer.addPostMapping("cancelledSparkJobs/:stageid", ctx -> this.getSparkSession().sparkContext().cancelStage(Integer.parseInt(ctx.param("stageid"))));
    }

    @FunctionalInterface
    public static interface OnSparkRestButtonAction {
        public void run();
    }

    @FunctionalInterface
    public static interface OnSparkButtonAction {
        public void run(Message var1);
    }

    public static class SparkUIFactoryImpl
    implements SparkUIFactory {
        SparkEngineWithUIImpl.SparkEngineWithUIFactory sparkEngineFactory;
        SparkUiDefaults sparkUiDefaults;
        private SingleSparkSession singleSparkSession;

        public SparkUIFactoryImpl(SparkEngineWithUIImpl.SparkEngineWithUIFactory sparkEngineWithUIFactory, SparkUiDefaults sparkUiDefaults, SingleSparkSession singleSparkSession) {
            this.sparkEngineFactory = sparkEngineWithUIFactory;
            this.sparkUiDefaults = sparkUiDefaults;
            this.singleSparkSession = singleSparkSession;
        }

        @Override
        public SparkUI create(SparkSession.Builder builder) {
            return new SparkUI(builder, this.sparkEngineFactory, this.sparkUiDefaults, this.singleSparkSession);
        }
    }

    public static interface SparkUIFactory {
        public SparkUI create(SparkSession.Builder var1);
    }
}

