/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.StacktraceHtmlPrinter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngineBase;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkVariable;
import java.util.Arrays;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.sql.SparkSession;
import org.jetbrains.annotations.NotNull;

public class SparkEngineWithUIImpl
extends SparkEngineBase
implements SparkEngineWithUI {
    SparkEngineWithUIImpl(SparkSession.Builder sparkSessionBuilder) {
        super(sparkSessionBuilder, SparkEngineWithUIImpl.errorPrinter());
        this.configureSparkSessionBuilder(this.sparkSessionBuilder);
    }

    @Override
    public TryResult configure(KernelFunctionality kernel, SparkUIApi sparkUI, Message parentMessage) {
        TryResult sparkSessionTry;
        SparkConf sparkConf = this.createSparkConf(sparkUI.getAdvancedOptions(), SparkEngineWithUIImpl.getSparkConfBasedOn(this.sparkSessionBuilder));
        sparkConf = this.configureSparkConf(sparkConf, sparkUI);
        this.sparkSessionBuilder = SparkSession.builder().config(sparkConf);
        if (sparkUI.getHiveSupport()) {
            this.sparkSessionBuilder.enableHiveSupport();
        }
        if ((sparkSessionTry = this.createSparkSession(sparkUI, parentMessage)).isError()) {
            return sparkSessionTry;
        }
        this.addListener(this.getOrCreate().sparkContext(), sparkUI);
        SparkVariable.putSparkSession(this.getOrCreate());
        TryResult tryResultSparkContext = this.initSparkContextInShell(kernel, parentMessage);
        if (!tryResultSparkContext.isError()) {
            kernel.registerCancelHook(SparkVariable::cancelAllJobs);
        }
        return tryResultSparkContext;
    }

    private SparkContext addListener(SparkContext sc, final SparkUIApi sparkUIManager) {
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onJobStart(SparkListenerJobStart jobStart) {
                super.onJobStart(jobStart);
            }

            public void onJobEnd(SparkListenerJobEnd jobEnd) {
                super.onJobEnd(jobEnd);
            }

            public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
                super.onStageSubmitted(stageSubmitted);
                sparkUIManager.startStage(stageSubmitted.stageInfo().stageId(), stageSubmitted.stageInfo().numTasks());
            }

            public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
                super.onStageCompleted(stageCompleted);
                sparkUIManager.endStage(stageCompleted.stageInfo().stageId());
            }

            public void onTaskStart(SparkListenerTaskStart taskStart) {
                super.onTaskStart(taskStart);
                sparkUIManager.taskStart(taskStart.stageId(), taskStart.taskInfo().taskId());
            }

            public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
                super.onTaskEnd(taskEnd);
                String reason = taskEnd.reason().toString();
                if (reason.equals("Success")) {
                    sparkUIManager.taskEnd(taskEnd.stageId(), taskEnd.taskInfo().taskId());
                } else if (reason.contains("stage cancelled")) {
                    sparkUIManager.taskCancelled(taskEnd.stageId(), taskEnd.taskInfo().taskId());
                }
            }
        });
        return sc;
    }

    private SparkSession.Builder configureSparkSessionBuilder(SparkSession.Builder builder) {
        builder.config("spark.extraListeners", "com.twosigma.beakerx.widget.StartStopSparkListener");
        builder.config("beakerx.id", UUID.randomUUID().toString());
        return builder;
    }

    @NotNull
    private static ErrorPrinter errorPrinter() {
        return e -> {
            CharSequence[] print = StacktraceHtmlPrinter.print((String[])((String[])Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).toArray(String[]::new)));
            return String.join((CharSequence)System.lineSeparator(), print);
        };
    }

    public static class SparkEngineWithUIFactoryImpl
    implements SparkEngineWithUIFactory {
        @Override
        public SparkEngineWithUI create(SparkSession.Builder sparkSessionBuilder) {
            return new SparkEngineWithUIImpl(sparkSessionBuilder);
        }
    }

    public static interface SparkEngineWithUIFactory {
        public SparkEngineWithUI create(SparkSession.Builder var1);
    }
}

