/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.scala.magic.command.SparkMagicActionOptions;
import com.twosigma.beakerx.scala.magic.command.SparkOptions;
import com.twosigma.beakerx.widget.SparkUI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class SparkMagicCommandOptions {
    private SparkOptions sparkOptions;
    private SparkMagicActionOptions sparkMagicCommand;

    public SparkMagicCommandOptions(SparkMagicActionOptions sparkMagicCommand) {
        this.sparkMagicCommand = sparkMagicCommand;
        this.sparkOptions = new SparkOptions();
    }

    public OptionsResult parseOptions(String[] args) {
        BasicParser parser = new BasicParser();
        ArrayList<SparkOptionCommand> commands = new ArrayList<SparkOptionCommand>();
        try {
            CommandLine cmd = parser.parse(this.sparkOptions.getOptions(), args);
            if (cmd.hasOption("start")) {
                commands.add(new SparkOptionCommand(){

                    @Override
                    public void run(SparkUI sparkUI, Message parent) {
                        SparkMagicCommandOptions.this.sparkMagicCommand.connectToSparkSession(sparkUI, parent);
                    }

                    @Override
                    public String getName() {
                        return "start";
                    }
                });
            }
            if (cmd.hasOption("noUI")) {
                commands.add(new SparkOptionCommand(){

                    @Override
                    public void run(SparkUI sparkUI, Message parent) {
                    }

                    @Override
                    public String getName() {
                        return "noUI";
                    }
                });
            }
        }
        catch (ParseException e) {
            return new ErrorOptionsResult(e.getMessage());
        }
        return new SparkOptionsResult(commands);
    }

    static interface SparkOptionCommand {
        public void run(SparkUI var1, Message var2);

        public String getName();
    }

    private class SparkOptionsResult
    implements OptionsResult {
        private List<SparkOptionCommand> sparkOptions;

        public SparkOptionsResult(List<SparkOptionCommand> sparkOptions) {
            this.sparkOptions = sparkOptions;
        }

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public String errorMsg() {
            return "";
        }

        @Override
        public List<SparkOptionCommand> options() {
            return this.sparkOptions;
        }
    }

    private class ErrorOptionsResult
    implements OptionsResult {
        private String error;

        public ErrorOptionsResult(String error) {
            this.error = error;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public String errorMsg() {
            return this.error;
        }

        @Override
        public List<SparkOptionCommand> options() {
            return new ArrayList<SparkOptionCommand>();
        }
    }

    public static interface OptionsResult {
        public boolean hasError();

        public String errorMsg();

        public List<SparkOptionCommand> options();
    }
}

