/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.twosigma.beakerx.autocomplete.MagicCommandAutocompletePatterns;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.autocomplete.MagicCommandAutocompletePatternsImpl;
import com.twosigma.beakerx.kernel.magic.command.FileServiceImpl;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfiguration;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddStaticImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AsyncMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.BashMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClassPathAddMvnCellMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddDynamicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddRepoMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathResetMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathShowMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlAliasMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JSMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JavaScriptMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LsMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.UnImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.ClojureMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.GroovyMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.JavaMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.KernelMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.KotlinMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.PythonMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.SQLMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic.ScalaMagicCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class MagicCommandConfigurationImpl
implements MagicCommandConfiguration {
    private MagicCommandAutocompletePatternsImpl autocompletePatterns = new MagicCommandAutocompletePatternsImpl();

    @Override
    public MagicCommandAutocompletePatterns patterns() {
        return this.autocompletePatterns;
    }

    @Override
    public List<MagicCommandType> createDefaults(KernelFunctionality kernel) {
        ArrayList<MagicCommandType> magicCommandTypes = new ArrayList<MagicCommandType>();
        magicCommandTypes.addAll(Arrays.asList(this.javascript(), this.js(), this.html(), this.HTML(), this.bash(), this.lsmagic(magicCommandTypes), this.addJar(kernel), this.addJarByMvn(kernel), this.addJarByMvnCell(kernel), this.addDynamic(kernel), this.addRepo(kernel), this.addClasspathReset(kernel), this.showClasspath(kernel), this.addStaticImport(kernel), this.addImport(kernel), this.unimport(kernel), this.timeLine(kernel), this.timeCell(kernel), this.timeItLine(kernel), this.timeItCell(kernel), this.loadMagic(kernel), this.kernel(kernel), this.python(kernel), this.clojure(kernel), this.groovy(kernel), this.java(kernel), this.kotlin(kernel), this.scala(kernel), this.sql(kernel), this.async(kernel)));
        return magicCommandTypes;
    }

    public MagicCommandType async(KernelFunctionality kernel) {
        return new MagicCommandType("%%async", "", new AsyncMagicCommand(kernel));
    }

    @Override
    public ClasspathAddMvnMagicCommand getClasspathAddMvnMagicCommand(KernelFunctionality kernel) {
        Optional<MagicCommandType> first = kernel.getMagicCommandTypes().stream().filter(x -> x.getCommand().equals("%classpath add mvn")).findFirst();
        return (ClasspathAddMvnMagicCommand)first.get().getMagicCommandFunctionality();
    }

    private MagicCommandType addClasspathReset(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath reset", "", new ClasspathResetMagicCommand(kernel, new FileServiceImpl()));
    }

    private MagicCommandType addDynamic(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add dynamic", "", new ClasspathAddDynamicMagicCommand(kernel));
    }

    private MagicCommandType loadMagic(KernelFunctionality kernel) {
        return new MagicCommandType("%load_magic", "", new LoadMagicMagicCommand(kernel));
    }

    private MagicCommandType timeItCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%timeit", "", new TimeItCellModeMagicCommand(kernel));
    }

    private MagicCommandType timeItLine(KernelFunctionality kernel) {
        return new MagicCommandType("%timeit", "", new TimeItLineModeMagicCommand(kernel));
    }

    private MagicCommandType timeCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%time", "", new TimeCellModeMagicCommand(kernel));
    }

    private MagicCommandType timeLine(KernelFunctionality kernel) {
        return new MagicCommandType("%time", "", new TimeLineModeMagicCommand(kernel));
    }

    private MagicCommandType unimport(KernelFunctionality kernel) {
        return new MagicCommandType("%unimport", "<classpath>", new UnImportMagicCommand(kernel));
    }

    private MagicCommandType addImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import", "<classpath>", new AddImportMagicCommand(kernel));
    }

    private MagicCommandType addStaticImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import static", "<classpath>", new AddStaticImportMagicCommand(kernel));
    }

    private MagicCommandType showClasspath(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath", "", new ClasspathShowMagicCommand(kernel));
    }

    private MagicCommandType addJarByMvn(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add mvn", "<group name version>", new ClasspathAddMvnMagicCommand(this.getMvnMagicCommandParams(kernel), kernel));
    }

    private MavenJarResolver.ResolverParams getMvnMagicCommandParams(KernelFunctionality kernel) {
        return new MavenJarResolver.ResolverParams(kernel.getCacheFolder().toString() + "/maven/cache", kernel.getTempFolder().toString() + MavenJarResolver.MVN_DIR);
    }

    private MagicCommandType addJarByMvnCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%classpath add mvn", "<group name version>", new ClassPathAddMvnCellMagicCommand(this.getMvnMagicCommandParams(kernel), kernel));
    }

    private MagicCommandType addJar(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add jar", "<jar path>", new ClasspathAddJarMagicCommand(kernel));
    }

    private MagicCommandType addRepo(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath config resolver", "<repoName repoUrl>", new ClasspathAddRepoMagicCommand(kernel));
    }

    private MagicCommandType lsmagic(List<MagicCommandType> magicCommandTypes) {
        return new MagicCommandType("%lsmagic", "", new LsMagicCommand(magicCommandTypes));
    }

    private MagicCommandType bash() {
        return new MagicCommandType("%%bash", "", new BashMagicCommand());
    }

    private MagicCommandType html() {
        return new MagicCommandType("%%html", "", new HtmlMagicCommand());
    }

    private MagicCommandType HTML() {
        return new MagicCommandType("%%HTML", "", new HtmlAliasMagicCommand());
    }

    private MagicCommandType javascript() {
        return new MagicCommandType("%%javascript", "", new JavaScriptMagicCommand());
    }

    private MagicCommandType js() {
        return new MagicCommandType("%%js", "", new JSMagicCommand());
    }

    private MagicCommandType kernel(KernelFunctionality kernel) {
        return new MagicCommandType("%%kernel", "", new KernelMagicCommand(kernel));
    }

    private MagicCommandType python(KernelFunctionality kernel) {
        return new MagicCommandType("%%python", "", new PythonMagicCommand(kernel));
    }

    private MagicCommandType sql(KernelFunctionality kernel) {
        return new MagicCommandType("%%sql", "", new SQLMagicCommand(kernel));
    }

    private MagicCommandType scala(KernelFunctionality kernel) {
        return new MagicCommandType("%%scala", "", new ScalaMagicCommand(kernel));
    }

    private MagicCommandType kotlin(KernelFunctionality kernel) {
        return new MagicCommandType("%%kotlin", "", new KotlinMagicCommand(kernel));
    }

    private MagicCommandType java(KernelFunctionality kernel) {
        return new MagicCommandType("%%java", "", new JavaMagicCommand(kernel));
    }

    private MagicCommandType groovy(KernelFunctionality kernel) {
        return new MagicCommandType("%%groovy", "", new GroovyMagicCommand(kernel));
    }

    private MagicCommandType clojure(KernelFunctionality kernel) {
        return new MagicCommandType("%%clojure", "", new ClojureMagicCommand(kernel));
    }
}

