/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.threads;

import com.twosigma.beakerx.jvm.threads.BeakerOutputHandler;
import com.twosigma.beakerx.jvm.threads.BxInputStream;
import com.twosigma.beakerx.jvm.threads.InputRequestMessageFactoryImpl;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.widget.OutputManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;

public class BeakerStdInOutErrHandler {
    private static BeakerStdInOutErrHandler instance;
    private ConcurrentHashMap<ThreadGroup, BeakerOutputHandlers> handlers = new ConcurrentHashMap();
    private PrintStream orig_out;
    private PrintStream orig_err;
    private KernelFunctionality kernel;
    private InputStream orig_in;

    public BeakerStdInOutErrHandler(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public static synchronized void init(KernelFunctionality kernel) {
        if (instance == null) {
            instance = new BeakerStdInOutErrHandler(kernel);
            instance.theinit();
        }
    }

    public static synchronized void fini() {
        if (instance != null) {
            instance.thefini();
            instance = null;
        }
    }

    public static synchronized void setOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err) {
        if (instance != null) {
            instance.theSetOutputHandler(out, err, Thread.currentThread().getThreadGroup());
        }
    }

    public static synchronized void clrOutputHandler() {
        if (instance != null) {
            instance.theClrOutputHandler();
        }
    }

    private void theinit() {
        this.orig_out = System.out;
        this.orig_err = System.err;
        this.orig_in = System.in;
        try {
            System.setOut(new PrintStream((OutputStream)new MyOutputStream(true), false, StandardCharsets.UTF_8.name()));
            System.setErr(new PrintStream((OutputStream)new MyOutputStream(false), false, StandardCharsets.UTF_8.name()));
            System.setIn(new BxInputStream(this.kernel, new InputRequestMessageFactoryImpl()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void thefini() {
        System.setOut(this.orig_out);
        System.setErr(this.orig_err);
        System.setIn(this.orig_in);
    }

    private synchronized void theSetOutputHandler(BeakerOutputHandler out, BeakerOutputHandler err, ThreadGroup threadGroup) {
        this.removeGroupsWithAllNoAliveThreads();
        this.handlers.put(threadGroup, new BeakerOutputHandlers(out, err));
    }

    private synchronized void removeGroupsWithAllNoAliveThreads() {
        this.handlers.entrySet().stream().filter(x -> ((ThreadGroup)x.getKey()).activeCount() == 0).forEach(y -> {
            BeakerOutputHandlers hrs = this.handlers.get(y.getKey());
            hrs.out_handler = null;
            hrs.err_handler = null;
            this.handlers.remove(y.getKey());
        });
    }

    private synchronized void theClrOutputHandler() {
        this.removeGroupsWithAllNoAliveThreads();
    }

    private synchronized void writeStdout(String text) throws IOException {
        boolean sendStdout = OutputManager.sendStdout(text);
        if (!sendStdout) {
            BeakerOutputHandlers hrs = this.handlers.get(Thread.currentThread().getThreadGroup());
            if (hrs != null && hrs.out_handler != null) {
                hrs.out_handler.write(text);
            } else {
                this.orig_out.write(text.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private synchronized void writeStderr(String text) throws IOException {
        boolean sendStderr = OutputManager.sendStderr(text);
        if (!sendStderr) {
            BeakerOutputHandlers hrs = this.handlers.get(Thread.currentThread().getThreadGroup());
            if (hrs != null && hrs.err_handler != null) {
                hrs.err_handler.write(text);
            } else {
                this.orig_err.write(text.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    static class BeakerOutputHandlers {
        BeakerOutputHandler out_handler;
        BeakerOutputHandler err_handler;

        BeakerOutputHandlers(BeakerOutputHandler out, BeakerOutputHandler err) {
            this.out_handler = out;
            this.err_handler = err;
        }
    }

    private class MyOutputStream
    extends OutputStream {
        private boolean is_out;

        public MyOutputStream(boolean isout) {
            this.is_out = isout;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] ba = new byte[]{(byte)b};
            String s = new String(ba, StandardCharsets.UTF_8);
            this.write(s);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String s = new String(b, StandardCharsets.UTF_8);
            this.write(s);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len, StandardCharsets.UTF_8);
            this.write(s);
        }

        private void write(String s) throws IOException {
            if (this.is_out) {
                instance.writeStdout(s);
            } else {
                instance.writeStderr(s);
            }
        }
    }
}

