/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.google.gson.Gson;
import com.twosigma.beakerx.AutotranslationService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;

public class AutotranslationServiceImpl
implements AutotranslationService {
    public static final String AUTHORIZATION = "Authorization";
    public static final String LOCALHOST = "http://localhost:";
    public static final String AUTOTRANSLTION = "/autotransltion/";
    public static final String BEAKERX = "beakerx";
    private final String contextAsString;
    private final AutotranslationContext context;

    public static AutotranslationService createAsSubkernel(String configuration) {
        return new AutotranslationServiceImpl(configuration);
    }

    public static AutotranslationService createAsMainKernel(String id) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("contextId", id);
        context.put("port", AutotranslationServiceImpl.autotranslationPort());
        Gson gson = new Gson();
        String contextAsString = gson.toJson(context);
        return new AutotranslationServiceImpl(contextAsString);
    }

    private AutotranslationServiceImpl(String configuration) {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(configuration, Map.class);
        String c = (String)map.get("contextId");
        String port = (String)map.get("port");
        this.context = new AutotranslationContext(c, port);
        this.contextAsString = configuration;
    }

    @Override
    public String getContextAsString() {
        return this.contextAsString;
    }

    @Override
    public String update(String name, String json) {
        try {
            String reply = Request.Post((String)(LOCALHOST + this.context.getPort() + AUTOTRANSLTION)).addHeader(AUTHORIZATION, this.auth()).bodyString(this.createBody(name, json), ContentType.APPLICATION_JSON).execute().returnContent().asString();
            if (!reply.equals("ok")) {
                throw new RuntimeException(reply);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    @Override
    public String get(String name) {
        String valueString = "";
        try {
            valueString = Request.Get((String)(LOCALHOST + this.context.getPort() + AUTOTRANSLTION + this.context.getContextId() + "/" + name)).addHeader(AUTHORIZATION, this.auth()).execute().returnContent().asString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return valueString;
    }

    private String createBody(String name, String json) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("name", name);
        context.put("json", json);
        context.put("sessionId", this.context.getContextId());
        Gson gson = new Gson();
        return gson.toJson(context);
    }

    private String auth() {
        String authString = AutotranslationServiceImpl.getBasic_auth_username() + ":" + AutotranslationServiceImpl.getBasic_auth_password();
        return "Basic " + Base64.encodeBase64String((byte[])authString.getBytes(StandardCharsets.UTF_8));
    }

    private static String getBasic_auth_username() {
        return BEAKERX;
    }

    private static String getBasic_auth_password() {
        return System.getenv("BEAKERX_AUTOTRANSLATION_PASSWORD");
    }

    private static String autotranslationPort() {
        return System.getenv("BEAKERX_AUTOTRANSLATION_PORT");
    }

    @Override
    public String close() {
        return "ok";
    }

    private static class AutotranslationContext {
        private String contextId;
        private String port;

        AutotranslationContext(String contextId, String port) {
            this.contextId = contextId;
            this.port = port;
        }

        public String getContextId() {
            return this.contextId;
        }

        public String getPort() {
            return this.port;
        }
    }
}

