/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.kernel;

import clojure.lang.LazySeq;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.BeakerXCommRepository;
import com.twosigma.beakerx.BeakerXJsonSerializer;
import com.twosigma.beakerx.CommRepository;
import com.twosigma.beakerx.DisplayerDataMapper;
import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.clojure.handlers.ClojureCommOpenHandler;
import com.twosigma.beakerx.clojure.handlers.ClojureKernelInfoHandler;
import com.twosigma.beakerx.clojure.kernel.ClojureBeakerXJsonSerializer;
import com.twosigma.beakerx.clojure.kernel.ClojureBeakerXServer;
import com.twosigma.beakerx.clojure.kernel.ClojureDefaultVariables;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.CacheFolderFactory;
import com.twosigma.beakerx.kernel.CloseKernelAction;
import com.twosigma.beakerx.kernel.ConfigurationFile;
import com.twosigma.beakerx.kernel.CustomMagicCommandsEmptyImpl;
import com.twosigma.beakerx.kernel.CustomMagicCommandsFactory;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.Kernel;
import com.twosigma.beakerx.kernel.KernelConfigurationFile;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelRunner;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.KernelSocketsFactoryImpl;
import com.twosigma.beakerx.kernel.Utils;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfiguration;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandConfigurationImpl;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.kernel.restserver.impl.GetUrlArgHandler;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jupyter.Displayer;
import jupyter.Displayers;

public class Clojure
extends Kernel {
    private static ObjectMapper mapper = new ObjectMapper();
    private static DisplayerDataMapper.Converter converter = data -> {
        if (data instanceof Collection) {
            String json = mapper.writeValueAsString(data);
            return mapper.readValue(json, Object.class);
        }
        return data;
    };

    private Clojure(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CommRepository commRepository, BeakerXServer beakerXServer, MagicCommandConfiguration magicCommandConfiguration) {
        super(sessionId, evaluator, kernelSocketsFactory, (CustomMagicCommandsFactory)new CustomMagicCommandsEmptyImpl(), commRepository, beakerXServer, magicCommandConfiguration);
    }

    public Clojure(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CloseKernelAction closeKernelAction, CacheFolderFactory cacheFolderFactory, CommRepository commRepository, BeakerXServer beakerXServer, MagicCommandConfiguration magicCommandConfiguration) {
        super(sessionId, evaluator, kernelSocketsFactory, closeKernelAction, cacheFolderFactory, (CustomMagicCommandsFactory)new CustomMagicCommandsEmptyImpl(), commRepository, beakerXServer, magicCommandConfiguration);
    }

    public CommOpenHandler getCommOpenHandler(Kernel kernel) {
        return new ClojureCommOpenHandler((KernelFunctionality)kernel);
    }

    public KernelHandler<Message> getKernelInfoHandler(Kernel kernel) {
        return new ClojureKernelInfoHandler((KernelFunctionality)kernel);
    }

    public static void main(String[] args) {
        KernelRunner.run(() -> {
            String id = Utils.uuid();
            BeakerXCommRepository beakerXCommRepository = new BeakerXCommRepository();
            KernelConfigurationFile configurationFile = new KernelConfigurationFile(args);
            KernelSocketsFactoryImpl kernelSocketsFactory = new KernelSocketsFactoryImpl((ConfigurationFile)configurationFile);
            NamespaceClient namespaceClient = NamespaceClient.create((String)id, (ConfigurationFile)configurationFile, (BeakerXJsonSerializer)new ClojureBeakerXJsonSerializer(), (CommRepository)beakerXCommRepository);
            MagicCommandConfigurationImpl magicConfiguration = new MagicCommandConfigurationImpl();
            ClojureEvaluator evaluator = new ClojureEvaluator(id, id, Clojure.getKernelParameters(), (BeakerXClient)namespaceClient, magicConfiguration.patterns());
            return new Clojure(id, (Evaluator)evaluator, (KernelSocketsFactory)kernelSocketsFactory, (CommRepository)beakerXCommRepository, (BeakerXServer)new ClojureBeakerXServer(new GetUrlArgHandler((BeakerXClient)namespaceClient)), (MagicCommandConfiguration)magicConfiguration);
        });
    }

    protected void configureMagicCommands() {
        super.configureMagicCommands();
        ClasspathAddMvnMagicCommand mvnMagicCommand = this.magicCommandConfiguration().getClasspathAddMvnMagicCommand((KernelFunctionality)this);
        mvnMagicCommand.addRepo("clojureRepo", "https://clojars.org/repo");
    }

    protected void configureJvmRepr() {
        Displayers.register(LazySeq.class, (Displayer)new Displayer<LazySeq>(){

            public Map<String, String> display(final LazySeq value) {
                return new HashMap<String, String>(){
                    {
                        List collect = Arrays.stream(value.toArray()).map(Object::toString).collect(Collectors.toList());
                        this.put("text/plain", new ArrayList(collect).toString());
                    }
                };
            }
        });
        DisplayerDataMapper.register((DisplayerDataMapper.Converter)converter);
    }

    private static EvaluatorParameters getKernelParameters() {
        HashMap<String, Collection> kernelParameters = new HashMap<String, Collection>();
        kernelParameters.put("imports", new ClojureDefaultVariables().getImports());
        return new EvaluatorParameters(kernelParameters);
    }
}

