/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.kotlin.evaluator.KotlinCodeRunner;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.Callable;

class KotlinWorkerThread
implements Callable<TryResult> {
    private static final String WRAPPER_CLASS_NAME = "BeakerWrapperClass1261714175";
    private KotlinEvaluator kotlinEvaluator;
    private final JobDescriptor j;

    public KotlinWorkerThread(KotlinEvaluator kotlinEvaluator, JobDescriptor j) {
        this.kotlinEvaluator = kotlinEvaluator;
        this.j = j;
    }

    @Override
    public TryResult call() throws Exception {
        TryResult.CellError either;
        try {
            this.j.outputObject.started();
            try {
                KotlinCodeRunner kotlinCodeRunner = new KotlinCodeRunner(this.j.outputObject, this.kotlinEvaluator.getClassLoader(), this.kotlinEvaluator.getRepl(), this.j.codeToBeExecuted);
                either = this.kotlinEvaluator.executeTask(kotlinCodeRunner, this.j.getExecutionOptions());
            }
            catch (Exception e) {
                either = TryResult.createError((String)e.getMessage());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            either = TryResult.createError((String)e.getMessage());
        }
        return either;
    }

    public void doExit() {
        this.removeKtFile();
    }

    private void removeKtFile() {
        try {
            Files.deleteIfExists(new File(this.kotlinEvaluator.getOutDir() + "\\" + WRAPPER_CLASS_NAME + ".kt").toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

