/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.translator.markdown;

import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/javalin/translator/markdown/JavalinCommonmarkPlugin;", "", "()V", "parser", "Lorg/commonmark/parser/Parser;", "renderer", "Lorg/commonmark/renderer/html/HtmlRenderer;", "configure", "", "staticHtmlRenderer", "staticMarkdownParser", "render", "", "markdownFilePath", "javalin"})
public final class JavalinCommonmarkPlugin {
    private static HtmlRenderer renderer;
    private static Parser parser;
    public static final JavalinCommonmarkPlugin INSTANCE;

    @JvmStatic
    public static final void configure(@NotNull HtmlRenderer staticHtmlRenderer, @NotNull Parser staticMarkdownParser) {
        Intrinsics.checkParameterIsNotNull((Object)staticHtmlRenderer, (String)"staticHtmlRenderer");
        Intrinsics.checkParameterIsNotNull((Object)staticMarkdownParser, (String)"staticMarkdownParser");
        renderer = staticHtmlRenderer;
        parser = staticMarkdownParser;
    }

    @NotNull
    public final String render(@NotNull String markdownFilePath) {
        Parser parser;
        Intrinsics.checkParameterIsNotNull((Object)markdownFilePath, (String)"markdownFilePath");
        HtmlRenderer htmlRenderer = renderer;
        if (htmlRenderer == null) {
            htmlRenderer = renderer = HtmlRenderer.builder().build();
        }
        if ((parser = JavalinCommonmarkPlugin.parser) == null) {
            parser = Parser.builder().build();
        }
        JavalinCommonmarkPlugin.parser = parser;
        URL uRL = JavalinCommonmarkPlugin.class.getResource(markdownFilePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"JavalinCommonmarkPlugin:\u2026esource(markdownFilePath)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        String fileContent = new String(byArray, charset);
        HtmlRenderer htmlRenderer2 = renderer;
        if (htmlRenderer2 == null) {
            Intrinsics.throwNpe();
        }
        Parser parser2 = JavalinCommonmarkPlugin.parser;
        if (parser2 == null) {
            Intrinsics.throwNpe();
        }
        String string = htmlRenderer2.render(parser2.parse(fileContent));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"renderer!!.render(parser!!.parse(fileContent))");
        return string;
    }

    private JavalinCommonmarkPlugin() {
    }

    static {
        JavalinCommonmarkPlugin javalinCommonmarkPlugin;
        INSTANCE = javalinCommonmarkPlugin = new JavalinCommonmarkPlugin();
    }
}

