/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.evaluator;

import com.twosigma.beakerx.AutocompleteNode;
import com.twosigma.beakerx.AutocompleteNodeFileSystem;
import com.twosigma.beakerx.AutocompleteNodeStatic;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.AutocompleteService;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AutocompleteServiceBeakerx
implements AutocompleteService {
    public static final String LAST_SPACE = " ";
    private Map<String, AutocompleteNode> patterns = new HashMap<String, AutocompleteNode>();

    public AutocompleteServiceBeakerx() {
        this.patterns.put("%classpath", new AutocompleteNodeStatic("%classpath", Arrays.asList(new AutocompleteNodeStatic("add", Arrays.asList(new AutocompleteNodeFileSystem("jar", AutocompleteNode.NO_CHILDREN), new AutocompleteNodeStatic("mvn", AutocompleteNode.NO_CHILDREN), new AutocompleteNodeStatic("dynamic", AutocompleteNode.NO_CHILDREN))))));
        this.patterns.put("%%classpath", new AutocompleteNodeStatic("%%classpath", Arrays.asList(new AutocompleteNodeStatic("add", Arrays.asList(new AutocompleteNodeStatic("mvn", AutocompleteNode.NO_CHILDREN))))));
    }

    @Override
    public AutocompleteResult find(String txt, int cur) {
        String expression = txt.substring(0, cur);
        LinkedList<String> parts = new LinkedList<String>(Arrays.asList(MagicCommandUtils.splitPath(expression)));
        Optional<AutocompleteResult> result = expression.endsWith(LAST_SPACE) ? this.findNextWord(parts, cur) : this.matchToTheWord(parts, expression);
        return result.orElseGet(() -> this.doAutocomplete(txt, cur));
    }

    private Optional<AutocompleteResult> findNextWord(LinkedList<String> parts, int cur) {
        String first = parts.removeFirst();
        AutocompleteNode node = this.patterns.get(first);
        if (node == null) {
            return Optional.empty();
        }
        List<String> result = node.findNextWord(parts);
        if (!result.isEmpty()) {
            return Optional.of(new AutocompleteResult(new ArrayList<String>(result), cur));
        }
        return Optional.empty();
    }

    private Optional<AutocompleteResult> matchToTheWord(LinkedList<String> parts, String txt) {
        if (parts.size() == 1) {
            List<AutocompleteNode> collect = this.findMatches(this.patterns.values(), txt);
            if (collect.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new AutocompleteResult(collect.stream().map(AutocompleteNode::getName).collect(Collectors.toList()), 0));
        }
        if (parts.size() > 1) {
            List<String> result;
            String last = parts.removeLast();
            String first = parts.removeFirst();
            AutocompleteNode node = this.patterns.get(first);
            if (node != null && !(result = node.matchToTheWord(parts, last)).isEmpty()) {
                return Optional.of(new AutocompleteResult(result, txt.length() - last.length()));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @NotNull
    private List<AutocompleteNode> findMatches(Collection<AutocompleteNode> nodes, String txt) {
        return nodes.stream().filter(x -> x.getName().startsWith(txt)).filter(x -> !x.getName().equals(txt)).collect(Collectors.toList());
    }

    protected abstract AutocompleteResult doAutocomplete(String var1, int var2);
}

