/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.AutocompleteNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AutocompleteNodeStatic
extends AutocompleteNode {
    public AutocompleteNodeStatic(String name, List<AutocompleteNode> children) {
        super(name, children);
    }

    @Override
    public List<String> matchToTheWord(LinkedList<String> parts, String last) {
        if (parts.isEmpty()) {
            return this.findMatches(this.getChildren(), last);
        }
        Optional<AutocompleteNode> node = this.findNode(parts);
        if (node.isPresent()) {
            return node.get().matchToTheWord(parts, last);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> findNextWord(LinkedList<String> parts) {
        if (parts.isEmpty()) {
            return this.getChildren().stream().map(x -> x.getName()).collect(Collectors.toList());
        }
        Optional<AutocompleteNode> node = this.findNode(parts);
        if (node.isPresent()) {
            return node.get().findNextWord(parts);
        }
        return new ArrayList<String>();
    }

    private List<String> findMatches(Collection<AutocompleteNode> nodes, String txt) {
        return nodes.stream().filter(x -> x.getName().startsWith(txt)).filter(x -> !x.getName().equals(txt)).map(x -> x.getName()).collect(Collectors.toList());
    }

    private Optional<AutocompleteNode> findNode(LinkedList<String> parts) {
        String first = parts.removeFirst();
        return this.getChildren().stream().filter(x -> x.getName().equals(first)).findFirst();
    }
}

