/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.scala.magic.command.SparkMagicActionOptions;
import com.twosigma.beakerx.scala.magic.command.SparkMagicCommand;
import com.twosigma.beakerx.scala.magic.command.SparkOptions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;

public class SparkMagicCommandOptions {
    private SparkOptions sparkOptions;
    private SparkMagicActionOptions sparkMagicCommand;

    public SparkMagicCommandOptions(SparkMagicActionOptions sparkMagicCommand) {
        this.sparkMagicCommand = sparkMagicCommand;
        this.sparkOptions = new SparkOptions();
    }

    public OptionsResult parseOptions(String[] args) {
        BasicParser parser = new BasicParser();
        ArrayList<SparkMagicCommand.SparkOptionCommand> commands = new ArrayList<SparkMagicCommand.SparkOptionCommand>();
        try {
            CommandLine cmd = parser.parse(this.sparkOptions.getOptions(), args);
            if (cmd.hasOption("start")) {
                commands.add((sparkUI, parent) -> this.sparkMagicCommand.connectToSparkSession(sparkUI, parent));
            }
        }
        catch (ParseException e) {
            return new ErrorOptionsResult(e.getMessage());
        }
        return new SparkOptionsResult(commands);
    }

    private class SparkOptionsResult
    implements OptionsResult {
        private List<SparkMagicCommand.SparkOptionCommand> sparkOptions;

        public SparkOptionsResult(List<SparkMagicCommand.SparkOptionCommand> sparkOptions) {
            this.sparkOptions = sparkOptions;
        }

        @Override
        public boolean hasError() {
            return false;
        }

        @Override
        public String errorMsg() {
            return "";
        }

        @Override
        public List<SparkMagicCommand.SparkOptionCommand> options() {
            return this.sparkOptions;
        }
    }

    private class ErrorOptionsResult
    implements OptionsResult {
        private String error;

        public ErrorOptionsResult(String error) {
            this.error = error;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public String errorMsg() {
            return this.error;
        }

        @Override
        public List<SparkMagicCommand.SparkOptionCommand> options() {
            return new ArrayList<SparkMagicCommand.SparkOptionCommand>();
        }
    }

    public static interface OptionsResult {
        public boolean hasError();

        public String errorMsg();

        public List<SparkMagicCommand.SparkOptionCommand> options();
    }
}

