/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.templateLanguages;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;

public class TemplateLanguageUtil {
    private TemplateLanguageUtil() {
    }

    @Nullable
    public static PsiFile getTemplateFile(PsiFile file2) {
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider instanceof TemplateLanguageFileViewProvider) {
            return viewProvider.getPsi(((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage());
        }
        return null;
    }

    public static PsiFile getBaseFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/templateLanguages/TemplateLanguageUtil", "getBaseFile"));
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    public static boolean isInsideTemplateFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/templateLanguages/TemplateLanguageUtil", "isInsideTemplateFile"));
        }
        return element.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }
}

