/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.BeakerXClient;
import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.classloader.BeakerXUrlClassLoader;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kotlin.evaluator.KotlinWorkerThread;
import com.twosigma.beakerx.kotlin.evaluator.ReplWithClassLoaderFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executors;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;

public class KotlinEvaluator
extends BaseEvaluator {
    private ClasspathScanner cps = new ClasspathScanner();
    private ReplInterpreter repl;
    private ReplClassLoader loader = null;
    private BeakerXUrlClassLoader kotlinClassLoader;

    public KotlinEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("kotlin"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters, beakerxClient);
    }

    public KotlinEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters, BeakerXClient beakerxClient) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters, beakerxClient);
        this.createRepl();
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath, this.outDir);
        this.cps = new ClasspathScanner(cpp);
        this.createRepl();
        this.executorService.shutdown();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    private void createRepl() {
        this.kotlinClassLoader = ReplWithClassLoaderFactory.createParentClassLoader(this);
        ReplWithClassLoaderFactory.ReplWithClassLoader replWithClassLoader = ReplWithClassLoaderFactory.createReplWithKotlinParentClassLoader(this, this.kotlinClassLoader);
        this.repl = replWithClassLoader.getRepl();
        this.loader = replWithClassLoader.getLoader();
    }

    protected void addJarToClassLoader(PathToJar pathToJar) {
        this.kotlinClassLoader.addJar(pathToJar);
        this.repl = ReplWithClassLoaderFactory.createReplWithReplClassLoader(this, this.loader);
    }

    protected void addImportToClassLoader(ImportPath anImport) {
        this.repl.eval(ReplWithClassLoaderFactory.getImportString(Collections.singletonList(anImport)));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void exit() {
        super.exit();
        this.killAllThreads();
        this.executorService.shutdown();
    }

    public TryResult evaluate(SimpleEvaluationObject seo, String code, ExecutionOptions executionOptions) {
        return this.evaluate(seo, new KotlinWorkerThread(this, new JobDescriptor(code, seo, executionOptions)));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        ArrayList ret = new ArrayList();
        return new AutocompleteResult(ret, -1);
    }

    private String createClasspath(Classpath classPath, String outDir) {
        String cpp = "";
        for (String pt : classPath.getPathsAsStrings()) {
            cpp = cpp + pt;
            cpp = cpp + File.pathSeparator;
        }
        cpp = cpp + File.pathSeparator;
        cpp = cpp + outDir;
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public ReplInterpreter getRepl() {
        return this.repl;
    }
}

