/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.groovy.evaluator.GroovyCodeRunner;
import com.twosigma.beakerx.groovy.evaluator.GroovyEvaluator;
import com.twosigma.beakerx.groovy.evaluator.GroovyNotFoundException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroovyWorkerThread
implements Callable<TryResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyWorkerThread.class.getName());
    private final JobDescriptor j;
    protected GroovyEvaluator groovyEvaluator;

    GroovyWorkerThread(GroovyEvaluator groovyEvaluator, JobDescriptor j) {
        this.groovyEvaluator = groovyEvaluator;
        this.j = j;
    }

    @Override
    public TryResult call() {
        TryResult.CellError r;
        Object nc = null;
        try {
            this.j.outputObject.started();
            String code = this.j.codeToBeExecuted;
            r = this.groovyEvaluator.executeTask(new GroovyCodeRunner(this.groovyEvaluator, code, this.j.outputObject));
        }
        catch (Throwable e) {
            if (e instanceof GroovyNotFoundException) {
                logger.warn(e.getLocalizedMessage());
                r = TryResult.createError((String)e.getLocalizedMessage());
            }
            e.printStackTrace();
            r = TryResult.createError((String)e.getLocalizedMessage());
        }
        return r;
    }
}

