/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.twosigma.beakerx.BeakerXJsonSerializer;
import com.twosigma.beakerx.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beakerx.table.TableDisplayToJson;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class DefaultBeakerXJsonSerializer
implements BeakerXJsonSerializer {
    private final BasicObjectSerializer objectSerializer;
    private ObjectMapper objectMapper = new ObjectMapper();

    public DefaultBeakerXJsonSerializer() {
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)TableDisplayToJson.tableDisplayModule());
        this.objectSerializer = new BasicObjectSerializer();
    }

    @Override
    public String toJson(Object value) {
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator jgen = this.objectMapper.getFactory().createGenerator((Writer)sw);
            this.objectSerializer.writeObject(value, jgen, true);
            jgen.flush();
            sw.flush();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object fromJson(String json) {
        try {
            return this.objectMapper.readValue(json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

