/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.CommRepository;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.comm.TargetNamesEnum;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class BeakerXCommRepository
implements CommRepository {
    private Map<String, Comm> commMap = new ConcurrentHashMap<String, Comm>();

    @Override
    public Comm getOrCreateAutotranslationComm() {
        Comm commByTargetName = this.getCommByTargetName(TargetNamesEnum.BEAKER_AUTOTRANSLATION.getTargetName());
        if (commByTargetName != null) {
            return commByTargetName;
        }
        Comm autotranslationComm = new Comm(TargetNamesEnum.BEAKER_AUTOTRANSLATION);
        autotranslationComm.open();
        return autotranslationComm;
    }

    @Override
    public Comm getCommByTargetName(String targetName) {
        Stream<Map.Entry> entryStream = this.commMap.entrySet().stream().filter(x -> ((Comm)x.getValue()).getTargetName().equals(targetName));
        Optional<Map.Entry> first = entryStream.findFirst();
        if (first.isPresent()) {
            return (Comm)first.get().getValue();
        }
        return null;
    }

    @Override
    public void closeComms() {
        this.commMap.values().forEach(Comm::close);
    }

    @Override
    public synchronized boolean isCommPresent(String hash) {
        return this.commMap.containsKey(hash);
    }

    @Override
    public Set<String> getCommHashSet() {
        return this.commMap.keySet();
    }

    @Override
    public synchronized void addComm(String hash, Comm commObject) {
        if (!this.isCommPresent(hash)) {
            this.commMap.put(hash, commObject);
        }
    }

    @Override
    public synchronized Comm getComm(String hash) {
        return this.commMap.get(hash != null ? hash : "");
    }

    @Override
    public synchronized void removeComm(String hash) {
        if (hash != null && this.isCommPresent(hash)) {
            this.commMap.remove(hash);
        }
    }
}

