/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private BigDecimal value;
    private byte[] rawData;
    private int rawScale;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDecimal.class);
    private static final int BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(BigDecimal.class);

    @Override
    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (null != this.rawData) {
            n += this.rawData.length;
        }
        return n;
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public SQLDecimal(BigDecimal bigDecimal, int n, int n2) throws StandardException {
        this.value = bigDecimal;
        if (this.value != null && n2 >= 0) {
            this.value = this.value.setScale(n2, RoundingMode.DOWN);
        }
    }

    public SQLDecimal(String string) {
        this.value = new BigDecimal(string);
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -128L && l <= 127L) {
                return (byte)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -32768L && l <= 32767L) {
                return (short)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    @Override
    public long getLong() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0L;
        }
        if (bigDecimal.compareTo(MINLONG_MINUS_ONE) == 1 && bigDecimal.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return bigDecimal.longValue();
        }
        throw StandardException.newException("22003", "BIGINT");
    }

    @Override
    public float getFloat() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0f;
        }
        float f = NumberDataType.normalizeREAL(bigDecimal.floatValue());
        return f;
    }

    @Override
    public double getDouble() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0;
        }
        double d = NumberDataType.normalizeDOUBLE(bigDecimal.doubleValue());
        return d;
    }

    private BigDecimal getBigDecimal() {
        if (this.value == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger(this.rawData), this.rawScale);
        }
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 3;
    }

    @Override
    public boolean getBoolean() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public String getString() {
        BigDecimal bigDecimal = this.getBigDecimal();
        return bigDecimal == null ? null : bigDecimal.toPlainString();
    }

    @Override
    public Object getObject() {
        return this.getBigDecimal();
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue((BigDecimal)object);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setCoreValue(SQLDecimal.getBigDecimal(dataValueDescriptor));
    }

    @Override
    public int getLength() {
        return this.getDecimalValuePrecision();
    }

    @Override
    public String getTypeName() {
        return "DECIMAL";
    }

    @Override
    public int getTypeFormatId() {
        return 200;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        int n;
        if (this.value != null) {
            n = this.value.scale();
            if (n < 0) {
                n = 0;
                this.value = this.value.setScale(0);
            }
            BigInteger bigInteger = this.value.unscaledValue();
            byArray = bigInteger.toByteArray();
        } else {
            n = this.rawScale;
            byArray = this.rawData;
        }
        objectOutput.writeByte(n);
        objectOutput.writeByte(byArray.length);
        objectOutput.write(byArray);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = null;
        this.rawScale = objectInput.readUnsignedByte();
        int n = objectInput.readUnsignedByte();
        if (this.rawData == null || n != this.rawData.length) {
            this.rawData = new byte[n];
        }
        objectInput.readFully(this.rawData);
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        BigDecimal bigDecimal = SQLDecimal.getBigDecimal(dataValueDescriptor);
        return this.getBigDecimal().compareTo(bigDecimal);
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLDecimal(this.getBigDecimal());
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getBigDecimal(n);
        this.rawData = null;
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 3);
            return;
        }
        preparedStatement.setBigDecimal(n, this.getBigDecimal());
    }

    @Override
    public void setValue(String string) throws StandardException {
        this.rawData = null;
        if (string == null) {
            this.value = null;
        } else {
            try {
                string = string.trim();
                this.value = new BigDecimal(string);
                this.rawData = null;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    public void setValue(double d) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(d));
    }

    @Override
    public void setValue(float f) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(f));
    }

    @Override
    public void setValue(long l) {
        this.value = BigDecimal.valueOf(l);
        this.rawData = null;
    }

    @Override
    public void setValue(int n) {
        this.setValue((long)n);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        this.setCoreValue(bigDecimal);
    }

    @Override
    public void setValue(Number number) throws StandardException {
        if (number instanceof BigDecimal || number == null) {
            this.setCoreValue((BigDecimal)number);
        } else {
            this.setValue(number.longValue());
        }
    }

    @Override
    public void setValue(boolean bl) {
        this.setCoreValue(bl ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.rawData = null;
    }

    private void setCoreValue(double d) {
        this.value = new BigDecimal(Double.toString(d));
        this.rawData = null;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getScale();
        int n2 = dataTypeDescriptor.getPrecision();
        this.setFrom(dataValueDescriptor);
        this.setWidth(n2, n, true);
    }

    @Override
    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).add(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).subtract(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).multiply(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3, -1);
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        BigDecimal bigDecimal = SQLDecimal.getBigDecimal(numberDataValue2);
        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        BigDecimal bigDecimal2 = SQLDecimal.getBigDecimal(numberDataValue);
        numberDataValue3.setBigDecimal(bigDecimal2.divide(bigDecimal, n > -1 ? n : Math.max(bigDecimal2.scale() + SQLDecimal.getWholeDigits(bigDecimal) + 1, 4), RoundingMode.DOWN));
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLDecimal();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setBigDecimal(this.getBigDecimal().negate());
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(BigDecimal.ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }

    public int hashCode() {
        long l;
        double d;
        BigDecimal bigDecimal = this.getBigDecimal();
        double d2 = d = bigDecimal != null ? bigDecimal.doubleValue() : 0.0;
        if (Double.isInfinite(d)) {
            l = bigDecimal.longValue();
        } else {
            l = (long)d;
            if ((double)l != d) {
                l = Double.doubleToLongBits(d);
            }
        }
        return (int)(l ^ l >> 32);
    }

    @Override
    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (n != -1 && n - n2 < SQLDecimal.getWholeDigits(this.getBigDecimal())) {
            throw StandardException.newException("22003", "DECIMAL/NUMERIC(" + n + "," + n2 + ")");
        }
        this.value = this.value.setScale(n2, RoundingMode.DOWN);
        this.rawData = null;
    }

    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigDecimal bigDecimal = this.getBigDecimal();
        return SQLDecimal.getWholeDigits(bigDecimal) + this.getDecimalValueScale();
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value == null) {
            return this.rawScale;
        }
        int n = this.value.scale();
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public static BigDecimal getBigDecimal(DataValueDescriptor dataValueDescriptor) throws StandardException {
        switch (dataValueDescriptor.typeToBigDecimal()) {
            case 3: {
                return (BigDecimal)dataValueDescriptor.getObject();
            }
            case 1: {
                try {
                    return new BigDecimal(dataValueDescriptor.getString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "java.math.BigDecimal");
                }
            }
            case -5: {
                return BigDecimal.valueOf(dataValueDescriptor.getLong());
            }
        }
        return null;
    }

    private static int getWholeDigits(BigDecimal bigDecimal) {
        if (BigDecimal.ONE.compareTo(bigDecimal = bigDecimal.abs()) == 1) {
            return 0;
        }
        return bigDecimal.precision() - bigDecimal.scale();
    }
}

