/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.mimetype.MIMEContainer;
import com.twosigma.beakerx.table.CellHighlighter;
import com.twosigma.beakerx.table.ColumnType;
import com.twosigma.beakerx.table.ContextMenuAction;
import com.twosigma.beakerx.table.FontColorProvider;
import com.twosigma.beakerx.table.RowFilter;
import com.twosigma.beakerx.table.TableDisplayActions;
import com.twosigma.beakerx.table.TableDisplayAlignmentProvider;
import com.twosigma.beakerx.table.TableDisplayConverter;
import com.twosigma.beakerx.table.TableDisplayToJson;
import com.twosigma.beakerx.table.TooltipAction;
import com.twosigma.beakerx.table.action.TableActionDetails;
import com.twosigma.beakerx.table.format.TableDisplayStringFormat;
import com.twosigma.beakerx.table.format.ValueStringFormat;
import com.twosigma.beakerx.table.highlight.TableDisplayCellHighlighter;
import com.twosigma.beakerx.table.highlight.ValueHighlighter;
import com.twosigma.beakerx.table.renderer.TableDisplayCellRenderer;
import com.twosigma.beakerx.widget.BeakerxWidget;
import com.twosigma.beakerx.widget.CompiledCodeRunner;
import com.twosigma.beakerx.widget.RunWidgetClosure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TableDisplay
extends BeakerxWidget {
    public static final String VIEW_NAME_VALUE = "TableDisplayView";
    public static final String MODEL_NAME_VALUE = "TableDisplayModel";
    public static final String TABLE_DISPLAY_SUBTYPE = "TableDisplay";
    public static final String LIST_OF_MAPS_SUBTYPE = "ListOfMaps";
    public static final String MATRIX_SUBTYPE = "Matrix";
    public static final String DICTIONARY_SUBTYPE = "Dictionary";
    private final List<List<?>> values;
    private List<String> columns;
    private final List<String> classes;
    private String subtype;
    private TimeUnit stringFormatForTimes;
    private Map<ColumnType, TableDisplayStringFormat> stringFormatForType = new HashMap<ColumnType, TableDisplayStringFormat>();
    private Map<String, TableDisplayStringFormat> stringFormatForColumn = new HashMap<String, TableDisplayStringFormat>();
    private Map<ColumnType, TableDisplayCellRenderer> rendererForType = new HashMap<ColumnType, TableDisplayCellRenderer>();
    private Map<String, TableDisplayCellRenderer> rendererForColumn = new HashMap<String, TableDisplayCellRenderer>();
    private Map<ColumnType, TableDisplayAlignmentProvider> alignmentForType = new HashMap<ColumnType, TableDisplayAlignmentProvider>();
    private Map<String, TableDisplayAlignmentProvider> alignmentForColumn = new HashMap<String, TableDisplayAlignmentProvider>();
    private Map<String, Boolean> columnsFrozen = new HashMap<String, Boolean>();
    private Map<String, Boolean> columnsFrozenRight = new HashMap<String, Boolean>();
    private Map<String, Boolean> columnsVisible = new HashMap<String, Boolean>();
    private List<String> columnOrder = new ArrayList<String>();
    private List<TableDisplayCellHighlighter> cellHighlighters = new ArrayList<TableDisplayCellHighlighter>();
    private List<List<String>> tooltips = new ArrayList<List<String>>();
    private Integer dataFontSize;
    private Integer headerFontSize;
    private List<List<Color>> fontColor = new ArrayList<List<Color>>();
    private List<List<?>> filteredValues;
    private boolean headersVertical;
    private String hasIndex;
    private String timeZone;
    private Object doubleClickListener;
    private String doubleClickTag;
    private Map<String, Object> contextMenuListeners = new HashMap<String, Object>();
    private Map<String, String> contextMenuTags = new HashMap<String, String>();
    private TableActionDetails details;
    private TableDisplayActions displayActions = new TableDisplayActions(this);
    public int ROWS_LIMIT = 100000;
    public int ROW_LIMIT_TO_INDEX = 10000;
    private String rowLimitMsg = "Note: table is too big to display.\n      The limit is %s rows, but this table has %s rows. \n      The first %s rows are displayed as a preview.";

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public TableDisplay(List<List<?>> v, List<String> co, List<String> cl) {
        this.values = new ArrayList();
        this.columns = co;
        this.classes = cl;
        this.subtype = TABLE_DISPLAY_SUBTYPE;
        this.openComm();
        this.addToValues(v);
    }

    public TableDisplay(Collection<Map<String, Object>> v) {
        this(v, new BasicObjectSerializer());
    }

    public TableDisplay(Map<String, Object>[] v) {
        this(new ArrayList<Map<String, Object>>(Arrays.asList(v)), new BasicObjectSerializer());
    }

    public TableDisplay(Collection<Map<String, Object>> v, BeakerObjectConverter serializer) {
        this.values = new ArrayList();
        this.columns = new ArrayList<String>();
        this.classes = new ArrayList<String>();
        this.subtype = LIST_OF_MAPS_SUBTYPE;
        if (v.size() > 0) {
            ArrayList<String> columnOrder = new ArrayList<String>();
            ArrayList<String> columnsToCheck = new ArrayList<String>();
            LinkedHashMap<String, String> typeTracker = new LinkedHashMap<String, String>();
            Map<String, Object> firstRow = v.iterator().next();
            for (String columnName : firstRow.keySet()) {
                columnOrder.add(columnName);
                columnsToCheck.add(columnName);
                typeTracker.put(columnName, null);
            }
            ArrayList<String> columnsToRemove = new ArrayList<String>();
            for (Map<String, Object> row : v) {
                for (String columnToRemove : columnsToRemove) {
                    columnsToCheck.remove(columnToRemove);
                }
                columnsToRemove = new ArrayList();
                ListIterator columnCheckIterator = columnsToCheck.listIterator();
                while (columnCheckIterator.hasNext()) {
                    Object rowItem;
                    String columnToCheck = (String)columnCheckIterator.next();
                    String currentType = (String)typeTracker.get(columnToCheck);
                    if (currentType != null && currentType.equals("string") || (rowItem = row.get(columnToCheck)) == null) continue;
                    String colType = rowItem.getClass().getName();
                    String beakerColType = serializer.convertType(colType);
                    typeTracker.put(columnToCheck, beakerColType);
                    if (!beakerColType.equals("string")) continue;
                    columnsToRemove.add(columnToCheck);
                }
            }
            for (String columnName : columnOrder) {
                String columnType = (String)typeTracker.get(columnName);
                this.columns.add(columnName);
                this.classes.add(columnType);
            }
        }
        this.openComm();
        this.addToValues(this.buildValues(v, serializer));
    }

    public TableDisplay(Map<?, ?> v) {
        this.values = new ArrayList();
        this.columns = Arrays.asList("Key", "Value");
        this.classes = new ArrayList<String>();
        this.subtype = DICTIONARY_SUBTYPE;
        this.openComm();
        this.addToValues(this.buildValuesFromMap(v));
    }

    public TableDisplay(int rowCount, int columnCount, List<String> columnNames, Element element) {
        this(TableDisplayConverter.convert(rowCount, columnCount, columnNames, element));
    }

    private void addToValues(List<List<?>> items) {
        this.values.addAll(items);
    }

    private List<List<?>> buildValues(Collection<Map<String, Object>> v, BeakerObjectConverter serializer) {
        ArrayList values = new ArrayList();
        for (Map<String, Object> m : v) {
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String cn : this.columns) {
                if (m.containsKey(cn)) {
                    vals.add(this.getValueForSerializer(m.get(cn), serializer));
                    continue;
                }
                vals.add(null);
            }
            values.add(vals);
        }
        return values;
    }

    private List<List<?>> buildValuesFromMap(Map<?, ?> v) {
        Set<Map.Entry<?, ?>> w = v.entrySet();
        ArrayList values = new ArrayList();
        Iterator<Map.Entry<?, ?>> iterator = w.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> s;
            Map.Entry<?, ?> e = s = iterator.next();
            values.add(Arrays.asList(e.getKey().toString(), e.getValue()));
        }
        return values;
    }

    public static TableDisplay createTableDisplayForMap(Map<?, ?> v) {
        return new TableDisplay(v);
    }

    @Override
    protected void openComm() {
        super.openComm();
        this.getComm().addMsgCallbackList(message -> this.displayActions.handleSetDetails((Message)message));
        this.getComm().addMsgCallbackList(message -> this.displayActions.handleOnContextMenu((Message)message));
        this.getComm().addMsgCallbackList(message -> this.displayActions.handleDoubleClick((Message)message));
    }

    public TimeUnit getStringFormatForTimes() {
        return this.stringFormatForTimes;
    }

    public void setStringFormatForTimes(TimeUnit stringFormatForTimes) {
        this.stringFormatForTimes = stringFormatForTimes;
        this.sendModelUpdate(TableDisplayToJson.serializeStringFormatForTimes(this.stringFormatForTimes));
    }

    public Map<ColumnType, TableDisplayStringFormat> getStringFormatForType() {
        return this.stringFormatForType;
    }

    public void setStringFormatForType(ColumnType type, TableDisplayStringFormat format) {
        this.stringFormatForType.put(type, format);
        this.sendModelUpdate(TableDisplayToJson.serializeStringFormatForType(this.stringFormatForType));
    }

    public Map<String, TableDisplayStringFormat> getStringFormatForColumn() {
        return this.stringFormatForColumn;
    }

    public void setStringFormatForColumn(String column, TableDisplayStringFormat format) {
        this.stringFormatForColumn.put(column, format);
        this.sendModelUpdate(TableDisplayToJson.serializeStringFormatForColumn(this.stringFormatForColumn));
    }

    public void setStringFormatForColumn(String column, Object closure) {
        int colIndex = this.columns.indexOf(column);
        if (colIndex == -1) {
            throw new IllegalArgumentException("Column " + column + " doesn't exist");
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        try {
            for (int row = 0; row < this.values.size(); ++row) {
                Object value = this.values.get(row).get(colIndex);
                Object[] params = new Object[]{value, row, colIndex, this};
                formattedValues.add((String)this.runClosure(closure, params));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not create format using closure.", e);
        }
        this.stringFormatForColumn.put(column, new ValueStringFormat(column, formattedValues));
        this.sendModelUpdate(TableDisplayToJson.serializeStringFormatForColumn(this.stringFormatForColumn));
    }

    public Map<ColumnType, TableDisplayCellRenderer> getRendererForType() {
        return this.rendererForType;
    }

    public void setRendererForType(ColumnType type, TableDisplayCellRenderer renderer) {
        this.rendererForType.put(type, renderer);
        this.sendModelUpdate(TableDisplayToJson.serializeRendererForType(this.rendererForType));
    }

    public Map<String, TableDisplayCellRenderer> getRendererForColumn() {
        return this.rendererForColumn;
    }

    public void setRendererForColumn(String column, TableDisplayCellRenderer renderer) {
        this.rendererForColumn.put(column, renderer);
        this.sendModelUpdate(TableDisplayToJson.serializeRendererForColumn(this.rendererForColumn));
    }

    public Map<ColumnType, TableDisplayAlignmentProvider> getAlignmentForType() {
        return this.alignmentForType;
    }

    public void setAlignmentProviderForType(ColumnType type, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForType.put(type, alignmentProvider);
        this.sendModelUpdate(TableDisplayToJson.serializeAlignmentForType(this.alignmentForType));
    }

    public Map<String, TableDisplayAlignmentProvider> getAlignmentForColumn() {
        return this.alignmentForColumn;
    }

    public void setAlignmentProviderForColumn(String column, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForColumn.put(column, alignmentProvider);
        this.sendModelUpdate(TableDisplayToJson.serializeAlignmentForColumn(this.alignmentForColumn));
    }

    public Map<String, Boolean> getColumnsFrozen() {
        return this.columnsFrozen;
    }

    public void setColumnFrozen(String column, boolean frozen) {
        this.columnsFrozen.put(column, frozen);
        this.sendModelUpdate(TableDisplayToJson.serializeColumnsFrozen(this.columnsFrozen));
    }

    public Map<String, Boolean> getColumnsFrozenRight() {
        return this.columnsFrozenRight;
    }

    public void setColumnFrozenRight(String column, boolean frozen) {
        this.columnsFrozenRight.put(column, frozen);
        this.sendModelUpdate(TableDisplayToJson.serializeColumnsFrozenRight(this.columnsFrozenRight));
    }

    public Map<String, Boolean> getColumnsVisible() {
        return this.columnsVisible;
    }

    public void setColumnVisible(String column, boolean visible) {
        this.columnsVisible.put(column, visible);
        this.sendModelUpdate(TableDisplayToJson.serializeColumnsVisible(this.columnsVisible));
    }

    public List<String> getColumnOrder() {
        return this.columnOrder;
    }

    public List<TableDisplayCellHighlighter> getCellHighlighters() {
        return this.cellHighlighters;
    }

    public void addCellHighlighter(TableDisplayCellHighlighter cellHighlighter) {
        this.cellHighlighters.add(cellHighlighter);
        this.sendModelUpdate(TableDisplayToJson.serializeCellHighlighters(this.cellHighlighters));
    }

    public void addCellHighlighter(Object closure) {
        HashMap colors = new HashMap();
        try {
            int rowSize = this.values.get(0).size();
            for (int colInd = 0; colInd < rowSize; ++colInd) {
                boolean hasHighlightedValues = false;
                ArrayList<Color> columnColors = new ArrayList<Color>();
                for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    Color color = (Color)this.runClosure(closure, params);
                    if (color != null) {
                        hasHighlightedValues = true;
                    }
                    columnColors.add(color);
                }
                if (!hasHighlightedValues) continue;
                this.addCellHighlighter(new ValueHighlighter(this.columns.get(colInd), columnColors));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set cell highlighter using closure.", e);
        }
    }

    public void addCellHighlighter(CellHighlighter cellHighlighter) {
        HashMap colors = new HashMap();
        try {
            int rowSize = this.values.get(0).size();
            for (int colInd = 0; colInd < rowSize; ++colInd) {
                boolean hasHighlightedValues = false;
                ArrayList<Color> columnColors = new ArrayList<Color>();
                for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                    Color color = cellHighlighter.apply(rowInd, colInd, this);
                    if (color != null) {
                        hasHighlightedValues = true;
                    }
                    columnColors.add(color);
                }
                if (!hasHighlightedValues) continue;
                this.addCellHighlighter(new ValueHighlighter(this.columns.get(colInd), columnColors));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set cell highlighter using closure.", e);
        }
    }

    public void removeAllCellHighlighters() {
        this.cellHighlighters.clear();
        this.sendModelUpdate(TableDisplayToJson.serializeCellHighlighters(this.cellHighlighters));
    }

    public void setColumnOrder(List<String> columnOrder) {
        this.columnOrder = columnOrder;
        this.sendModelUpdate(TableDisplayToJson.serializeColumnOrder(this.columnOrder));
    }

    public void setToolTip(Object closure) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<String> rowToolTips = new ArrayList<String>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowToolTips.add((String)this.runClosure(closure, params));
                }
                this.tooltips.add(rowToolTips);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set tooltip using closure.", e);
        }
        this.sendModelUpdate(TableDisplayToJson.serializeTooltips(this.tooltips));
    }

    public void setTooltip(TooltipAction tooltip) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<String> rowToolTips = new ArrayList<String>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    rowToolTips.add(tooltip.apply(rowInd, colInd, this));
                }
                this.tooltips.add(rowToolTips);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set tooltip using closure.", e);
        }
        this.sendModelUpdate(TableDisplayToJson.serializeTooltips(this.tooltips));
    }

    public List<List<String>> getTooltips() {
        return this.tooltips;
    }

    public Integer getDataFontSize() {
        return this.dataFontSize;
    }

    public void setDataFontSize(Integer dataFontSize) {
        this.dataFontSize = dataFontSize;
        this.sendModelUpdate(TableDisplayToJson.serializeDataFontSize(this.dataFontSize));
    }

    public Integer getHeaderFontSize() {
        return this.headerFontSize;
    }

    public void setHeaderFontSize(Integer headerFontSize) {
        this.headerFontSize = headerFontSize;
        this.sendModelUpdate(TableDisplayToJson.serializeHeaderFontSize(this.headerFontSize));
    }

    public List<List<Color>> getFontColor() {
        return this.fontColor;
    }

    public void setFontColorProvider(Object closure) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<Color> rowFontColors = new ArrayList<Color>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowFontColors.add((Color)this.runClosure(closure, params));
                }
                this.fontColor.add(rowFontColors);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set font color using closure.", e);
        }
        this.sendModelUpdate(TableDisplayToJson.serializeFontColor(this.fontColor));
    }

    public void setFontColorProvider(FontColorProvider fontColorProvider) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<Color> rowFontColors = new ArrayList<Color>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    rowFontColors.add(fontColorProvider.apply(rowInd, colInd, this));
                }
                this.fontColor.add(rowFontColors);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set font color using closure.", e);
        }
        this.sendModelUpdate(TableDisplayToJson.serializeFontColor(this.fontColor));
    }

    public void setRowFilter(Object closure) {
        ArrayList filteredValues = new ArrayList();
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                Object[] params = new Object[]{rowInd, this.values};
                if (!((Boolean)this.runClosure(closure, params)).booleanValue()) continue;
                filteredValues.add(this.values.get(rowInd));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set row filter using closure.", e);
        }
        this.filteredValues = filteredValues;
        this.sendModelUpdate(TableDisplayToJson.serializeFilteredValues(this.filteredValues));
    }

    public void setRowFilter(RowFilter rowFilter) {
        ArrayList filteredValues = new ArrayList();
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                if (!rowFilter.apply(rowInd, this.values).booleanValue()) continue;
                filteredValues.add(this.values.get(rowInd));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set row filter using closure.", e);
        }
        this.filteredValues = filteredValues;
        this.sendModelUpdate(TableDisplayToJson.serializeFilteredValues(this.filteredValues));
    }

    public void setHeadersVertical(boolean headersVertical) {
        this.headersVertical = headersVertical;
        this.sendModelUpdate(TableDisplayToJson.serializeHeadersVertical(this.headersVertical));
    }

    public Boolean getHeadersVertical() {
        return this.headersVertical;
    }

    public void setHasIndex(String hasIndex) {
        this.hasIndex = hasIndex;
        this.sendModelUpdate(TableDisplayToJson.serializeHasIndex(this.hasIndex));
    }

    public String getHasIndex() {
        return this.hasIndex;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        this.sendModelUpdate(TableDisplayToJson.serializeTimeZone(this.timeZone));
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public List<List<?>> getFilteredValues() {
        return this.filteredValues;
    }

    public static List<Map<String, Object>> getValuesAsRows(List<List<?>> values, List<String> columns) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (columns != null && values != null) {
            for (List<?> value : values) {
                HashMap m = new HashMap();
                for (int c = 0; c < columns.size(); ++c) {
                    if (value.size() <= c) continue;
                    m.put(columns.get(c), value.get(c));
                }
                rows.add(m);
            }
        } else {
            throw new IllegalArgumentException("Method 'getValuesAsRows' doesn't supported for this table");
        }
        return rows;
    }

    public static List<List<?>> getValuesAsMatrix(List<List<?>> values) {
        return values;
    }

    public static Map<String, Object> getValuesAsDictionary(List<List<?>> values) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (List<?> l : values) {
            m.put(l.get(0).toString(), l.get(1));
        }
        return m;
    }

    public List<Map<String, Object>> getValuesAsRows() {
        return TableDisplay.getValuesAsRows(this.values, this.columns);
    }

    public List<List<?>> getValuesAsMatrix() {
        return TableDisplay.getValuesAsMatrix(this.values);
    }

    public Map<String, Object> getValuesAsDictionary() {
        return TableDisplay.getValuesAsDictionary(this.values);
    }

    private Object getValueForSerializer(Object value, BeakerObjectConverter serializer) {
        if (value != null) {
            String clazz = serializer.convertType(value.getClass().getName());
            if ("int64".equals(clazz) || "bigint".equals(clazz)) {
                return value.toString();
            }
            return value;
        }
        return null;
    }

    public List<List<?>> getValues() {
        return this.values;
    }

    public List<String> getColumnNames() {
        return this.columns;
    }

    public List<String> getTypes() {
        return this.classes;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setDoubleClickAction(String tagName) {
        this.doubleClickListener = null;
        this.doubleClickTag = tagName;
        this.sendModelUpdate(TableDisplayToJson.serializeDoubleClickAction(this.doubleClickTag, this.hasDoubleClickAction()));
    }

    public void setDoubleClickAction(Object listener) {
        this.doubleClickListener = listener;
        this.doubleClickTag = null;
        this.sendModelUpdate(TableDisplayToJson.serializeDoubleClickAction(this.doubleClickTag, this.hasDoubleClickAction()));
    }

    public void fireDoubleClick(List<Object> params, Message message) {
        if (this.doubleClickListener != null) {
            params.add(this);
            CompiledCodeRunner.runCompiledCode(message, this::doubleClickHandler, params);
            this.sendModel();
        }
    }

    public void fireContextMenuClick(String name, List<Object> params, Message message) {
        Object contextMenuListener = this.contextMenuListeners.get(name);
        if (contextMenuListener != null) {
            params.add(this);
            CompiledCodeRunner.runCompiledCode(message, this::contextMenuClickHandlerCommon, contextMenuListener, params);
            this.sendModel();
        }
    }

    private Object contextMenuClickHandlerCommon(Object ... params) throws Exception {
        Object actionObject = params[0];
        ArrayList other = (ArrayList)params[1];
        if (actionObject instanceof ContextMenuAction) {
            ContextMenuAction action = (ContextMenuAction)actionObject;
            action.apply((Integer)other.get(0), (Integer)other.get(1), this);
        } else {
            Object object = this.runClosure(params[0], other.toArray());
        }
        return MIMEContainer.HIDDEN;
    }

    public String getDoubleClickTag() {
        return this.doubleClickTag;
    }

    private Object doubleClickHandler(Object ... params) throws Exception {
        Object[] values = ((List)params[0]).toArray();
        Object ret = this.runClosure(this.doubleClickListener, values);
        return MIMEContainer.HIDDEN;
    }

    public boolean hasDoubleClickAction() {
        return this.doubleClickListener != null;
    }

    public void addContextMenuItem(String name, Object closure) {
        this.contextMenuListeners.put(name, closure);
    }

    public void addContextMenuItem(String name, String tagName) {
        this.contextMenuTags.put(name, tagName);
    }

    public Set<String> getContextMenuItems() {
        return this.contextMenuListeners.keySet();
    }

    public Map<String, String> getContextMenuTags() {
        return this.contextMenuTags;
    }

    public void setDetails(TableActionDetails details) {
        this.details = details;
    }

    public TableActionDetails getDetails() {
        return this.details;
    }

    protected Object runClosure(Object closure, Object ... params) throws Exception {
        return RunWidgetClosure.runClosure(closure, params);
    }

    @Override
    protected Map serializeToJsonObject() {
        return TableDisplayToJson.toJson(this);
    }

    @Override
    protected Map serializeToJsonObject(Object item) {
        return TableDisplayToJson.toJson(item);
    }

    public String getRowLimitMsg() {
        return String.format(this.rowLimitMsg, this.ROWS_LIMIT, this.values.size(), this.ROW_LIMIT_TO_INDEX);
    }

    public void updateCell(int row, String columnName, Object value) {
        int index = this.getColumnIndex(columnName);
        List<?> rowList = this.values.get(row);
        rowList.set(index, value);
    }

    private int getColumnIndex(String columnName) {
        int index = this.columns.indexOf(columnName);
        if (index < 0) {
            throw new RuntimeException("There is no given column name: " + columnName);
        }
        return index;
    }

    public void setRowLimitMsg(String rowLimitMsg) {
        this.rowLimitMsg = rowLimitMsg;
    }

    public static interface Element {
        public String get(int var1, int var2);
    }
}

