/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.serialization.JvmStringTable;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.load.kotlin.JavaFlexibleTypeDeserializer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.jvm.ClassMapperLite;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;
    private final StringTable stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final boolean useTypeTable;
    private final String moduleName;
    private final ClassBuilderMode classBuilderMode;

    public JvmSerializerExtension(@NotNull JvmSerializationBindings bindings, @NotNull GenerationState state2) {
        if (bindings == null) {
            JvmSerializerExtension.$$$reportNull$$$0(0);
        }
        if (state2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(1);
        }
        this.bindings = bindings;
        this.stringTable = new JvmStringTable(state2.getTypeMapper());
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
        this.useTypeTable = state2.getUseTypeTableInSerializer();
        this.moduleName = state2.getModuleName();
        this.classBuilderMode = state2.getClassBuilderMode();
    }

    @Override
    @NotNull
    public StringTable getStringTable() {
        StringTable stringTable = this.stringTable;
        if (stringTable == null) {
            JvmSerializerExtension.$$$reportNull$$$0(2);
        }
        return stringTable;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        if (descriptor2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(3);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(4);
        }
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto) {
        if (packageFqName == null) {
            JvmSerializerExtension.$$$reportNull$$$0(5);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(6);
        }
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        if (flexibleType == null) {
            JvmSerializerExtension.$$$reportNull$$$0(7);
        }
        if (lowerProto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(8);
        }
        if (upperProto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(9);
        }
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(JavaFlexibleTypeDeserializer.INSTANCE.getId()));
        if (flexibleType instanceof RawTypeImpl) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        if (type2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(10);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(11);
        }
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        if (typeParameter == null) {
            JvmSerializerExtension.$$$reportNull$$$0(12);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(13);
        }
        for (AnnotationDescriptor annotation2 : typeParameter.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature2;
        Method method;
        if (descriptor2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(14);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(15);
        }
        if ((method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2)) != null && (signature2 = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature2);
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature2;
        Method method;
        if (descriptor2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(16);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(17);
        }
        if ((method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2)) != null && (signature2 = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.methodSignature, signature2);
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        if (descriptor2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(18);
        }
        if (proto == null) {
            JvmSerializerExtension.$$$reportNull$$$0(19);
        }
        SignatureSerializer signatureSerializer = new SignatureSerializer();
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        PropertySetterDescriptor setter2 = descriptor2.getSetter();
        Method getterMethod = getter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter2);
        Method setterMethod = setter2 == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter2);
        Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, descriptor2);
        Method syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2);
        JvmProtoBuf.JvmPropertySignature signature2 = signatureSerializer.propertySignature(descriptor2, field != null ? (String)field.second : null, field != null ? ((Type)field.first).getDescriptor() : null, syntheticMethod != null ? signatureSerializer.methodSignature(null, syntheticMethod) : null, getterMethod != null ? signatureSerializer.methodSignature(null, getterMethod) : null, setterMethod != null ? signatureSerializer.methodSignature(null, setterMethod) : null);
        proto.setExtension(JvmProtoBuf.propertySignature, signature2);
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        if (type2 == null) {
            JvmSerializerExtension.$$$reportNull$$$0(20);
        }
        if (builder == null) {
            JvmSerializerExtension.$$$reportNull$$$0(21);
        }
        if (this.classBuilderMode == ClassBuilderMode.KAPT || this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder.setClassName(this.stringTable.getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type2, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension";
                break;
            }
            case 3: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flexibleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerProto";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperProto";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializePackage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serializeFlexibleType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializeType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeTypeParameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "serializeConstructor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "serializeFunction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "serializeProperty";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "serializeErrorType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SignatureSerializer {
        private SignatureSerializer() {
        }

        @Nullable
        public JvmProtoBuf.JvmMethodSignature methodSignature(@Nullable FunctionDescriptor descriptor2, @NotNull Method method) {
            if (method == null) {
                SignatureSerializer.$$$reportNull$$$0(0);
            }
            JvmProtoBuf.JvmMethodSignature.Builder builder = JvmProtoBuf.JvmMethodSignature.newBuilder();
            if (descriptor2 == null || !descriptor2.getName().asString().equals(method.getName())) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(method.getName()));
            }
            if (descriptor2 == null || this.requiresSignature(descriptor2, method.getDescriptor())) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(method.getDescriptor()));
            }
            return builder.hasName() || builder.hasDesc() ? builder.build() : null;
        }

        private boolean requiresSignature(@NotNull FunctionDescriptor descriptor2, @NotNull String desc) {
            String returnTypeDesc;
            if (descriptor2 == null) {
                SignatureSerializer.$$$reportNull$$$0(1);
            }
            if (desc == null) {
                SignatureSerializer.$$$reportNull$$$0(2);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                String receiverDesc = this.mapTypeDefault(receiverParameter.getValue().getType());
                if (receiverDesc == null) {
                    return true;
                }
                sb.append(receiverDesc);
            }
            for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
                String paramDesc = this.mapTypeDefault(valueParameter.getType());
                if (paramDesc == null) {
                    return true;
                }
                sb.append(paramDesc);
            }
            sb.append(")");
            KotlinType returnType = descriptor2.getReturnType();
            String string = returnTypeDesc = returnType == null ? "V" : this.mapTypeDefault(returnType);
            if (returnTypeDesc == null) {
                return true;
            }
            sb.append(returnTypeDesc);
            return !sb.toString().equals(desc);
        }

        private boolean requiresSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String desc) {
            if (descriptor2 == null) {
                SignatureSerializer.$$$reportNull$$$0(3);
            }
            if (desc == null) {
                SignatureSerializer.$$$reportNull$$$0(4);
            }
            return !desc.equals(this.mapTypeDefault(descriptor2.getType()));
        }

        @Nullable
        private String mapTypeDefault(@NotNull KotlinType type2) {
            ClassifierDescriptor classifier2;
            if (type2 == null) {
                SignatureSerializer.$$$reportNull$$$0(5);
            }
            if (!((classifier2 = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
                return null;
            }
            ClassId classId = this.classId((ClassDescriptor)classifier2);
            return classId == null ? null : ClassMapperLite.mapClass(classId);
        }

        @Nullable
        private ClassId classId(@NotNull ClassDescriptor descriptor2) {
            DeclarationDescriptor container2;
            if (descriptor2 == null) {
                SignatureSerializer.$$$reportNull$$$0(6);
            }
            if ((container2 = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor) {
                return ClassId.topLevel(((PackageFragmentDescriptor)container2).getFqName().child(descriptor2.getName()));
            }
            if (container2 instanceof ClassDescriptor) {
                ClassId outerClassId = this.classId((ClassDescriptor)container2);
                return outerClassId == null ? null : outerClassId.createNestedClassId(descriptor2.getName());
            }
            return null;
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature propertySignature(@NotNull PropertyDescriptor descriptor2, @Nullable String fieldName, @Nullable String fieldDesc, @Nullable JvmProtoBuf.JvmMethodSignature syntheticMethod, @Nullable JvmProtoBuf.JvmMethodSignature getter2, @Nullable JvmProtoBuf.JvmMethodSignature setter2) {
            if (descriptor2 == null) {
                SignatureSerializer.$$$reportNull$$$0(7);
            }
            JvmProtoBuf.JvmPropertySignature.Builder signature2 = JvmProtoBuf.JvmPropertySignature.newBuilder();
            if (fieldDesc != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldDesc;
                signature2.setField(this.fieldSignature(descriptor2, fieldName, fieldDesc));
            }
            if (syntheticMethod != null) {
                signature2.setSyntheticMethod(syntheticMethod);
            }
            if (getter2 != null) {
                signature2.setGetter(getter2);
            }
            if (setter2 != null) {
                signature2.setSetter(setter2);
            }
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = signature2.build();
            if (jvmPropertySignature == null) {
                SignatureSerializer.$$$reportNull$$$0(8);
            }
            return jvmPropertySignature;
        }

        @NotNull
        public JvmProtoBuf.JvmFieldSignature fieldSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String name, @NotNull String desc) {
            if (descriptor2 == null) {
                SignatureSerializer.$$$reportNull$$$0(9);
            }
            if (name == null) {
                SignatureSerializer.$$$reportNull$$$0(10);
            }
            if (desc == null) {
                SignatureSerializer.$$$reportNull$$$0(11);
            }
            JvmProtoBuf.JvmFieldSignature.Builder builder = JvmProtoBuf.JvmFieldSignature.newBuilder();
            if (!descriptor2.getName().asString().equals(name)) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(name));
            }
            if (this.requiresSignature(descriptor2, desc)) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(desc));
            }
            JvmProtoBuf.JvmFieldSignature jvmFieldSignature = builder.build();
            if (jvmFieldSignature == null) {
                SignatureSerializer.$$$reportNull$$$0(12);
            }
            return jvmFieldSignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "propertySignature";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fieldSignature";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "methodSignature";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "requiresSignature";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "mapTypeDefault";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "classId";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "propertySignature";
                    break;
                }
                case 8: 
                case 12: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "fieldSignature";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

