/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;

public class TimeItLineModeMagicCommand
extends TimeMagicCommand {
    public static final String TIMEIT_LINE = "%timeit";

    public TimeItLineModeMagicCommand(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public String getMagicCommandName() {
        return TIMEIT_LINE;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 0 && commandParts[0].equals(TIMEIT_LINE);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        Code code = param.getCode();
        Message message = param.getCode().getMessage();
        int executionCount = param.getExecutionCount();
        String codeToExecute = code.asString().replace(TIMEIT_LINE, "");
        codeToExecute = codeToExecute.replaceAll("(-.)(\\d*\\s)", "");
        try {
            return this.timeIt(this.buildTimeItOption(code), codeToExecute, message, executionCount);
        }
        catch (IllegalArgumentException e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, e.getMessage());
        }
    }
}

