/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandResult;
import com.twosigma.beakerx.mimetype.MIMEContainer;

public class HtmlMagicCommand
implements MagicCommandFunctionality {
    public static final String HTML = "%%html";

    @Override
    public String getMagicCommandName() {
        return HTML;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 0 && commandParts[0].equals(HTML);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String commandCodeBlock = param.getCommandCodeBlock();
        if (commandCodeBlock == null) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, String.format("UsageError: %s is a cell magic, but the cell body is empty.", HTML));
        }
        MIMEContainer html = MIMEContainer.HTML("<html>" + commandCodeBlock + "</html>");
        return new MagicCommandResult(MagicCommandOutcomeItem.Status.OK, html);
    }
}

