/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.ErrorData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ClasspathMagicCommand
implements MagicCommandFunctionality {
    public static final String CLASSPATH = "%classpath";
    protected KernelFunctionality kernel;

    public ClasspathMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public Collection<String> addJars(String path) {
        LinkedList addedJarsName = Lists.newLinkedList();
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            Map<Path, String> paths = this.getPaths(path);
            List<PathToJar> pathsToJars = paths.keySet().stream().map(currentPath -> new PathToJar(currentPath.toString())).collect(Collectors.toList());
            List<Path> addedPaths = this.kernel.addJarsToClasspath(pathsToJars);
            addedJarsName.addAll(addedPaths.stream().map(x -> x.getFileName().toString()).collect(Collectors.toList()));
        } else {
            Path currentPath2 = Paths.get(path, new String[0]);
            if (this.kernel.addJarToClasspath(new PathToJar(path))) {
                addedJarsName.add(currentPath2.getFileName().toString());
            }
        }
        return addedJarsName;
    }

    private Map<Path, String> getPaths(String pathWithWildcard) {
        String pathWithoutWildcards = pathWithWildcard.replace("*", "");
        try {
            return Files.list(Paths.get(pathWithoutWildcards, new String[0])).filter(path -> path.toString().toLowerCase().endsWith(".jar")).collect(Collectors.toMap(p -> p, o -> o.getFileName().toString()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create any jars files in selected path");
        }
    }

    private Boolean doesPathContainsWildCards(String path) {
        return path.contains("*");
    }

    private Boolean containsSingleWildcardSymbol(String path) {
        return path.length() - path.replace("*", "").length() == 1;
    }

    protected ErrorData isValidPath(String path) {
        boolean isEmpty = ((String)Preconditions.checkNotNull((Object)path)).isEmpty();
        if (isEmpty) {
            return new ErrorData(true, "Please provide a path");
        }
        if (this.doesPathContainsWildCards(path).booleanValue()) {
            if (!this.containsSingleWildcardSymbol(path).booleanValue() || !path.endsWith("*")) {
                return new ErrorData(true, "Bad classpath wildcard syntax, path can only end with *");
            }
            if (!Paths.get(path.replace("*", ""), new String[0]).toFile().exists()) {
                return new ErrorData(true, "Bad classpath, directory cannot be create");
            }
        } else if (!Paths.get(path, new String[0]).toFile().exists()) {
            return new ErrorData(true, "Bad classpath, file not found");
        }
        return new ErrorData(false, "");
    }
}

