/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.ErrorData;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class BashMagicCommand
implements MagicCommandFunctionality {
    public static final String BASH = "%%bash";

    @Override
    public String getMagicCommandName() {
        return BASH;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 0 && commandParts[0].equals(BASH);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        Code code = param.getCode();
        return code.getCodeBlock().map(codeWithoutCommand -> {
            ErrorData errorData = this.executeBashCode((String)codeWithoutCommand);
            if (errorData.hasError()) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, errorData.getMessage());
            }
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, errorData.getMessage());
        }).orElse(new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, String.format("UsageError: %s is a cell magic, but the cell body is empty.", BASH)));
    }

    private ErrorData executeBashCode(String code) {
        String[] cmd = new String[]{"/bin/bash", "-c", code};
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process process = pb.start();
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            process.destroy();
        }
        catch (IOException | InterruptedException e) {
            return new ErrorData(true, e.getMessage());
        }
        return new ErrorData(false, output.toString());
    }
}

