/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.Code;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.handler.MagicCommandExecutor;
import com.twosigma.beakerx.kernel.magic.command.CodeFactory;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Semaphore;

public class ExecuteRequestHandler
extends KernelHandler<Message> {
    private int executionCount = 0;
    private final Semaphore syncObject = new Semaphore(1, true);

    public ExecuteRequestHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        try {
            this.handleMsg(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMsg(Message message) throws Exception {
        this.syncObject.acquire();
        this.kernel.sendBusyMessage(message);
        ++this.executionCount;
        String codeString = this.takeCodeFrom(message);
        this.announceTheCode(message, codeString);
        Code code = CodeFactory.create(codeString, message, this.kernel);
        MagicCommandExecutor.executeMagicCommands(code, this.executionCount, this.kernel);
        this.executeCodeBlock(code);
    }

    private void finishExecution(Message message) {
        this.kernel.sendIdleMessage(message);
        this.syncObject.release();
    }

    private void executeCodeBlock(Code code) {
        if (code.getCodeBlock().isPresent()) {
            this.kernel.executeCode(code.getCodeBlock().get(), code.getMessage(), this.executionCount, seo -> this.finishExecution(seo.getJupyterMessage()));
        } else {
            this.finishExecution(code.getMessage());
        }
    }

    private String takeCodeFrom(Message message) {
        String code = "";
        if (message.getContent() != null && message.getContent().containsKey("code")) {
            code = ((String)((Object)message.getContent().get("code"))).trim();
        }
        return code;
    }

    private void announceTheCode(Message message, String code) {
        Message reply = new Message();
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        reply.setHeader(new Header(JupyterMessages.EXECUTE_INPUT, message.getHeader().getSession()));
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(2);
        map1.put("execution_count", Integer.valueOf(this.executionCount));
        map1.put("code", (Serializable)((Object)code));
        reply.setContent(map1);
        this.kernel.publish(reply);
    }

    @Override
    public void exit() {
    }
}

