/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.twosigma.beakerx.BeakerxToStringDisplayer;
import com.twosigma.beakerx.DisplayerDataMapper;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.Evaluator;
import com.twosigma.beakerx.evaluator.EvaluatorManager;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObjectWithTime;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.CloseKernelAction;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.Imports;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelHandlers;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.KernelSignalHandler;
import com.twosigma.beakerx.kernel.KernelSockets;
import com.twosigma.beakerx.kernel.KernelSocketsFactory;
import com.twosigma.beakerx.kernel.PathToJar;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.handler.CommOpenHandler;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandTypesFactory;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.kernel.threads.ExecutionResultSender;
import com.twosigma.beakerx.message.Message;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jupyter.Displayers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Kernel
implements KernelFunctionality {
    private static final Logger logger = LoggerFactory.getLogger(Kernel.class);
    public static String OS = System.getProperty("os.name").toLowerCase();
    public static boolean showNullExecutionResult = true;
    private final CloseKernelAction closeKernelAction;
    private String sessionId;
    private KernelSocketsFactory kernelSocketsFactory;
    private KernelHandlers handlers;
    private Map<String, Comm> commMap;
    private ExecutionResultSender executionResultSender;
    private EvaluatorManager evaluatorManager;
    private KernelSockets kernelSockets;
    private List<MagicCommandType> magicCommandTypes;

    public Kernel(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory) {
        this(sessionId, evaluator, kernelSocketsFactory, () -> System.exit(0));
    }

    protected Kernel(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory, CloseKernelAction closeKernelAction) {
        this.sessionId = sessionId;
        this.kernelSocketsFactory = kernelSocketsFactory;
        this.closeKernelAction = closeKernelAction;
        this.commMap = new ConcurrentHashMap<String, Comm>();
        this.executionResultSender = new ExecutionResultSender(this);
        this.evaluatorManager = new EvaluatorManager(this, evaluator);
        this.handlers = new KernelHandlers(this, this.getCommOpenHandler(this), this.getKernelInfoHandler(this));
        this.configureMagicCommands();
        DisplayerDataMapper.init();
        this.configureSignalHandler();
        this.intJvmRepr();
    }

    public abstract CommOpenHandler getCommOpenHandler(Kernel var1);

    public abstract KernelHandler<Message> getKernelInfoHandler(Kernel var1);

    @Override
    public void run() {
        KernelManager.register(this);
        logger.debug("Jupyter kernel starting.");
        this.kernelSockets = this.kernelSocketsFactory.create(this, this::closeComms);
        this.kernelSockets.start();
        try {
            this.kernelSockets.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.doExit();
            logger.debug("Jupyter kernel shoutdown.");
        }
    }

    private void doExit() {
        this.evaluatorManager.exit();
        this.handlers.exit();
        this.executionResultSender.exit();
        this.closeKernelAction.close();
    }

    private void closeComms() {
        this.commMap.values().forEach(Comm::close);
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    @Override
    public synchronized void setShellOptions(EvaluatorParameters kernelParameters) {
        this.evaluatorManager.setShellOptions(kernelParameters);
    }

    @Override
    public synchronized void cancelExecution() {
        this.evaluatorManager.cancelExecution();
    }

    @Override
    public synchronized boolean isCommPresent(String hash) {
        return this.commMap.containsKey(hash);
    }

    @Override
    public Set<String> getCommHashSet() {
        return this.commMap.keySet();
    }

    @Override
    public synchronized void addComm(String hash, Comm commObject) {
        if (!this.isCommPresent(hash)) {
            this.commMap.put(hash, commObject);
        }
    }

    @Override
    public synchronized Comm getComm(String hash) {
        return this.commMap.get(hash != null ? hash : "");
    }

    @Override
    public synchronized void removeComm(String hash) {
        if (hash != null && this.isCommPresent(hash)) {
            this.commMap.remove(hash);
        }
    }

    @Override
    public synchronized void publish(Message message) {
        this.kernelSockets.publish(message);
    }

    @Override
    public synchronized void send(Message message) {
        this.kernelSockets.send(message);
    }

    @Override
    public Handler<Message> getHandler(JupyterMessages type) {
        return this.handlers.get(type);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public ExecutionResultSender getExecutionResultSender() {
        return this.executionResultSender;
    }

    private void configureSignalHandler() {
        if (!Kernel.isWindows()) {
            KernelSignalHandler.addSigIntHandler(this::cancelExecution);
        }
    }

    @Override
    public SimpleEvaluationObject executeCode(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallback executeCodeCallback) {
        return this.evaluatorManager.executeCode(code, message, executionCount, executeCodeCallback);
    }

    @Override
    public SimpleEvaluationObjectWithTime executeCodeWithTimeMeasurement(String code, Message message, int executionCount, KernelFunctionality.ExecuteCodeCallbackWithTime executeCodeCallbackWithTime) {
        return this.evaluatorManager.executeCodeWithTimeMeasurement(code, message, executionCount, executeCodeCallbackWithTime);
    }

    @Override
    public AutocompleteResult autocomplete(String code, int cursorPos) {
        return this.evaluatorManager.autocomplete(code, cursorPos);
    }

    @Override
    public boolean addJarToClasspath(PathToJar path) {
        return this.evaluatorManager.addJarToClasspath(path);
    }

    @Override
    public List<Path> addJarsToClasspath(List<PathToJar> paths) {
        return this.evaluatorManager.addJarsToClasspath(paths);
    }

    @Override
    public void sendBusyMessage(Message message) {
        this.publish(MessageCreator.createBusyMessage(message));
    }

    @Override
    public void sendIdleMessage(Message message) {
        this.publish(MessageCreator.createIdleMessage(message));
    }

    @Override
    public Classpath getClasspath() {
        return this.evaluatorManager.getClasspath();
    }

    @Override
    public Imports getImports() {
        return this.evaluatorManager.getImports();
    }

    @Override
    public void addImport(ImportPath anImport) {
        this.evaluatorManager.addImport(anImport);
    }

    @Override
    public void removeImport(ImportPath anImport) {
        this.evaluatorManager.removeImport(anImport);
    }

    @Override
    public Path getTempFolder() {
        return this.evaluatorManager.getTempFolder();
    }

    private void intJvmRepr() {
        Displayers.registration().setDefault(BeakerxToStringDisplayer.get());
        this.configureJvmRepr();
    }

    protected void configureJvmRepr() {
    }

    @Override
    public Class<?> loadClass(String clazzName) throws ClassNotFoundException {
        return this.evaluatorManager.loadClass(clazzName);
    }

    @Override
    public List<MagicCommandType> getMagicCommandTypes() {
        return this.magicCommandTypes;
    }

    private void configureMagicCommands() {
        this.magicCommandTypes = MagicCommandTypesFactory.createDefaults(this);
    }

    @Override
    public void registerMagicCommandType(MagicCommandType magicCommandType) {
        this.magicCommandTypes.add(magicCommandType);
    }
}

