/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.kernel.magic.command.MagicCommand;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.message.Message;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Code {
    private final String allCode;
    private final List<MagicCommand> magicCommands;
    private Optional<String> codeBlock;
    private final List<MagicCommandOutcomeItem> errors;
    private final Message message;

    private Code(String allCode, Optional<String> codeBlock, List<MagicCommand> magicCommands, List<MagicCommandOutcomeItem> errors, Message message) {
        this.allCode = allCode;
        this.magicCommands = (List)Preconditions.checkNotNull(magicCommands);
        this.errors = (List)Preconditions.checkNotNull(errors);
        this.message = message;
        this.codeBlock = codeBlock;
    }

    public static Code createCode(String allCode, String codeBlock, List<MagicCommand> magicCommands, List<MagicCommandOutcomeItem> errors, Message message) {
        return new Code(allCode, Optional.of(codeBlock), magicCommands, errors, message);
    }

    public static Code createCodeWithoutCodeBlock(String allCode, List<MagicCommand> magicCommands, List<MagicCommandOutcomeItem> errors, Message message) {
        return new Code(allCode, Optional.empty(), magicCommands, errors, message);
    }

    public Optional<String> getCodeBlock() {
        return this.codeBlock;
    }

    public String asString() {
        return this.allCode;
    }

    public List<MagicCommand> getMagicCommands() {
        return this.magicCommands;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<MagicCommandOutcomeItem> getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Message getMessage() {
        return this.message;
    }
}

