/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.evaluator;

import com.google.inject.Provider;
import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.jvm.serialization.ObjectSerializer;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.scala.evaluator.BeakerxObjectFactory;
import com.twosigma.beakerx.scala.evaluator.BeakerxObjectFactoryImpl;
import com.twosigma.beakerx.scala.evaluator.ScalaEvaluatorGlue;
import com.twosigma.beakerx.scala.evaluator.ScalaWorkerThread;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaCollectionSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaListOfPrimitiveTypeMapsSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeListOfListSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeMapSerializer;
import com.twosigma.beakerx.scala.serializers.ScalaTableDeSerializer;
import java.io.File;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaEvaluator
extends BaseEvaluator {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaEvaluator.class.getName());
    private BeakerxObjectFactory beakerxObjectFactory;
    private ScalaWorkerThread workerThread;
    private final Provider<BeakerObjectConverter> objectSerializerProvider;
    private static boolean autoTranslationSetup = false;
    private ClassLoader classLoader;
    private ScalaEvaluatorGlue shell;
    private String loader_cp = "";
    private ScalaEvaluatorGlue acshell;
    private String acloader_cp = "";

    public ScalaEvaluator(String id, String sId, Provider<BeakerObjectConverter> osp, EvaluatorParameters evaluatorParameters) {
        this(id, sId, osp, (CellExecutor)new BeakerCellExecutor("scala"), new BeakerxObjectFactoryImpl(), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters);
    }

    public ScalaEvaluator(String id, String sId, Provider<BeakerObjectConverter> osp, CellExecutor cellExecutor, BeakerxObjectFactory beakerxObjectFactory, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters);
        this.objectSerializerProvider = osp;
        this.beakerxObjectFactory = beakerxObjectFactory;
        this.newEvaluator();
        this.workerThread = new ScalaWorkerThread(this);
        this.workerThread.start();
        try {
            this.newAutoCompleteEvaluator();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void doResetEnvironment() {
        this.clearShell();
        this.newEvaluator();
        try {
            this.newAutoCompleteEvaluator();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.workerThread.halt();
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        if (this.acshell != null) {
            int lineStart = 0;
            String[] sv = code.substring(0, caretPosition).split("\n");
            for (int i = 0; i < sv.length - 1; ++i) {
                this.acshell.evaluate2(sv[i]);
                caretPosition -= sv[i].length() + 1;
                lineStart += sv[i].length() + 1;
            }
            AutocompleteResult lineCompletion = this.acshell.autocomplete(sv[sv.length - 1], caretPosition);
            return new AutocompleteResult(lineCompletion.getMatches(), lineCompletion.getStartIndex() + lineStart);
        }
        return null;
    }

    public void setupAutoTranslation() {
        if (autoTranslationSetup) {
            return;
        }
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaCollectionSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaMapSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeListOfListSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaListOfPrimitiveTypeMapsSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeSerializer((ObjectSerializer)new ScalaPrimitiveTypeMapSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaCollectionDeserializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaMapDeserializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        ((BeakerObjectConverter)this.objectSerializerProvider.get()).addfTypeDeserializer((ObjectDeserializer)new ScalaTableDeSerializer((BeakerObjectConverter)this.objectSerializerProvider.get()));
        autoTranslationSetup = true;
    }

    String adjustImport(String imp) {
        if (imp.startsWith("import")) {
            imp = imp.substring(6).trim();
        }
        if (imp.startsWith("static")) {
            imp = imp.substring(6).trim();
        }
        if (imp.contains(".object.")) {
            imp = imp.replace(".object.", ".`object`.");
        }
        if (imp.endsWith(".*")) {
            imp = imp.substring(0, imp.length() - 1) + "_";
        }
        return imp;
    }

    private ClassLoader newAutoCompleteClassLoader() throws MalformedURLException {
        logger.debug("creating new autocomplete loader");
        this.acloader_cp = "";
        for (int i = 0; i < this.classPath.size(); ++i) {
            this.acloader_cp = this.acloader_cp + this.classPath.get(i);
            this.acloader_cp = this.acloader_cp + File.pathSeparatorChar;
        }
        this.acloader_cp = this.acloader_cp + this.outDir;
        DynamicClassLoaderSimple cl = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        cl.addJars(this.classPath.getPathsAsStrings());
        cl.addDynamicDir(this.outDir);
        return cl;
    }

    private void newAutoCompleteEvaluator() throws MalformedURLException {
        logger.debug("creating new autocomplete evaluator");
        this.acshell = new ScalaEvaluatorGlue(this.newAutoCompleteClassLoader(), this.acloader_cp + File.pathSeparatorChar + System.getProperty("java.class.path"), this.outDir);
        if (!this.imports.isEmpty()) {
            for (int i = 0; i < this.imports.getImportPaths().size(); ++i) {
                String imp = ((ImportPath)this.imports.getImportPaths().get(i)).asString().trim();
                if ((imp = this.adjustImport(imp)).isEmpty() || this.acshell.addImport(imp)) continue;
                logger.warn("ERROR: cannot add import '{}'", (Object)imp);
            }
        }
        NamespaceClient.getBeaker((String)this.sessionId);
        String r = this.acshell.evaluate2(this.beakerxObjectFactory.create(this.sessionId));
        if (r != null && !r.isEmpty()) {
            logger.warn("ERROR creating beaker beaker: {}", (Object)r);
        }
    }

    void newEvaluator() {
        logger.debug("creating new evaluator");
        this.classLoader = this.newClassLoader();
        this.shell = new ScalaEvaluatorGlue(this.classLoader, this.loader_cp + File.pathSeparatorChar + System.getProperty("java.class.path"), this.getOutDir());
        if (!this.getImports().isEmpty()) {
            for (int i = 0; i < this.getImports().getImportPaths().size(); ++i) {
                String imp = ((ImportPath)this.getImports().getImportPaths().get(i)).asString().trim();
                if ((imp = this.adjustImport(imp)).isEmpty()) continue;
                logger.debug("importing : {}", (Object)imp);
                if (this.shell.addImport(imp)) continue;
                logger.warn("ERROR: cannot add import '{}'", (Object)imp);
            }
        }
        logger.debug("creating beaker object");
        NamespaceClient.getBeaker((String)this.getSessionId());
        String r = this.shell.evaluate2(this.beakerxObjectFactory.create(this.getSessionId()));
        if (r != null && !r.isEmpty()) {
            logger.warn("ERROR creating beaker object: {}", (Object)r);
        }
    }

    private ClassLoader newClassLoader() {
        logger.debug("creating new loader");
        this.loader_cp = "";
        for (int i = 0; i < this.getClasspath().size(); ++i) {
            this.loader_cp = this.loader_cp + this.getClasspath().get(i);
            this.loader_cp = this.loader_cp + File.pathSeparatorChar;
        }
        this.loader_cp = this.loader_cp + this.getOutDir();
        DynamicClassLoaderSimple cl = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        cl.addJars(this.getClasspath().getPathsAsStrings());
        cl.addDynamicDir(this.getOutDir());
        return cl;
    }

    public ScalaEvaluatorGlue getShell() {
        return this.shell;
    }

    public void clearShell() {
        this.shell = null;
    }
}

