/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.groovy.autocomplete.GroovyAutocomplete;
import com.twosigma.beakerx.groovy.autocomplete.GroovyClasspathScanner;
import com.twosigma.beakerx.groovy.evaluator.EnvVariablesFilter;
import com.twosigma.beakerx.groovy.evaluator.GroovyClassLoaderFactory;
import com.twosigma.beakerx.groovy.evaluator.GroovyWorkerThread;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kernel.PathToJar;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import java.io.File;

public class GroovyEvaluator
extends BaseEvaluator {
    public static boolean LOCAL_DEV = false;
    private GroovyClasspathScanner cps = new GroovyClasspathScanner();
    private GroovyAutocomplete gac = this.createGroovyAutocomplete(this.cps);
    private GroovyWorkerThread worker = null;
    private GroovyClassLoader groovyClassLoader;
    private Binding scriptBinding = null;

    public GroovyEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("groovy"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters);
    }

    public GroovyEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters);
        this.outDir = EnvVariablesFilter.envVariablesFilter(this.outDir, System.getenv());
        this.reloadClassloader();
        this.worker = new GroovyWorkerThread(this);
        this.worker.start();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.worker.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        return this.gac.doAutocomplete(code, caretPosition, (ClassLoader)this.groovyClassLoader, this.imports);
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath);
        this.cps = new GroovyClasspathScanner(cpp);
        this.gac = this.createGroovyAutocomplete(this.cps);
        this.reloadClassloader();
        this.worker.halt();
    }

    public void exit() {
        super.exit();
        this.worker.doExit();
        this.cancelExecution();
        this.worker.halt();
    }

    protected boolean addJar(PathToJar path) {
        return this.classPath.add(new PathToJar(EnvVariablesFilter.envVariablesFilter(path.getPath(), System.getenv())));
    }

    private GroovyAutocomplete createGroovyAutocomplete(GroovyClasspathScanner c) {
        return new GroovyAutocomplete(c);
    }

    private String createClasspath(Classpath classPath) {
        StringBuilder cppBuilder = new StringBuilder();
        for (String pt : classPath.getPathsAsStrings()) {
            cppBuilder.append(pt);
            cppBuilder.append(File.pathSeparator);
        }
        String cpp = cppBuilder.toString();
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public ClassLoader getClassLoader() {
        return this.groovyClassLoader;
    }

    private void reloadClassloader() {
        this.groovyClassLoader = GroovyClassLoaderFactory.newEvaluator(this.getImports(), this.getClasspath(), this.getOutDir());
        this.scriptBinding = new Binding();
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.groovyClassLoader;
    }

    public Binding getScriptBinding() {
        return this.scriptBinding;
    }
}

