/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.twosigma.beakerx.autocomplete.AutocompleteResult;
import com.twosigma.beakerx.autocomplete.ClasspathScanner;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.TempFolderFactory;
import com.twosigma.beakerx.evaluator.TempFolderFactoryImpl;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.jvm.threads.BeakerCellExecutor;
import com.twosigma.beakerx.jvm.threads.CellExecutor;
import com.twosigma.beakerx.kernel.Classpath;
import com.twosigma.beakerx.kernel.EvaluatorParameters;
import com.twosigma.beakerx.kotlin.evaluator.KotlinWorkerThread;
import com.twosigma.beakerx.kotlin.evaluator.ReplWithClassLoaderFactory;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;

public class KotlinEvaluator
extends BaseEvaluator {
    private final String packageId = "com.twosigma.beaker.kotlin.bkr" + this.shellId.split("-")[0];
    private ClasspathScanner cps = new ClasspathScanner();
    private KotlinWorkerThread workerThread;
    private ReplInterpreter repl;
    private ReplClassLoader loader = null;

    public KotlinEvaluator(String id, String sId, EvaluatorParameters evaluatorParameters) {
        this(id, sId, (CellExecutor)new BeakerCellExecutor("kotlin"), (TempFolderFactory)new TempFolderFactoryImpl(), evaluatorParameters);
    }

    public KotlinEvaluator(String id, String sId, CellExecutor cellExecutor, TempFolderFactory tempFolderFactory, EvaluatorParameters evaluatorParameters) {
        super(id, sId, cellExecutor, tempFolderFactory, evaluatorParameters);
        ReplWithClassLoaderFactory.ReplWithClassLoader replWithClassLoader = ReplWithClassLoaderFactory.createReplWithClassLoader(this);
        this.repl = replWithClassLoader.getRepl();
        this.loader = replWithClassLoader.getLoader();
        this.workerThread = new KotlinWorkerThread(this);
        this.workerThread.start();
    }

    protected void doResetEnvironment() {
        String cpp = this.createClasspath(this.classPath, this.outDir);
        this.cps = new ClasspathScanner(cpp);
        ReplWithClassLoaderFactory.ReplWithClassLoader replWithClassLoader = ReplWithClassLoaderFactory.createReplWithClassLoader(this);
        this.repl = replWithClassLoader.getRepl();
        this.loader = replWithClassLoader.getLoader();
        this.workerThread.halt();
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void exit() {
        super.exit();
        this.workerThread.doExit();
        this.cancelExecution();
        this.workerThread.halt();
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        this.workerThread.add(new JobDescriptor(code, seo));
    }

    public AutocompleteResult autocomplete(String code, int caretPosition) {
        ArrayList ret = new ArrayList();
        return new AutocompleteResult(ret, -1);
    }

    private String createClasspath(Classpath classPath, String outDir) {
        String cpp = "";
        for (String pt : classPath.getPathsAsStrings()) {
            cpp = cpp + pt;
            cpp = cpp + File.pathSeparator;
        }
        cpp = cpp + File.pathSeparator;
        cpp = cpp + outDir;
        cpp = cpp + File.pathSeparator;
        cpp = cpp + System.getProperty("java.class.path");
        return cpp;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public ReplInterpreter getRepl() {
        return this.repl;
    }
}

