/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command;

import com.google.common.collect.Lists;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.MavenJarResolver;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.AddStaticImportMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.BashMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddJarMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathAddMvnMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathRemoveMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathShowMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.HtmlMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.JavaScriptMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LoadMagicMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.LsMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItCellModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeItLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.TimeLineModeMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.UnImportMagicCommand;
import java.util.ArrayList;
import java.util.List;

public class MagicCommandTypesFactory {
    public static List<MagicCommandType> createDefaults(KernelFunctionality kernel) {
        ArrayList<MagicCommandType> magicCommandTypes = new ArrayList<MagicCommandType>();
        magicCommandTypes.addAll(Lists.newArrayList((Object[])new MagicCommandType[]{MagicCommandTypesFactory.javascript(), MagicCommandTypesFactory.html(), MagicCommandTypesFactory.bash(), MagicCommandTypesFactory.lsmagic(magicCommandTypes), MagicCommandTypesFactory.addJar(kernel), MagicCommandTypesFactory.addJarByMvn(kernel), MagicCommandTypesFactory.removeJar(kernel), MagicCommandTypesFactory.showClasspath(kernel), MagicCommandTypesFactory.addStaticImport(kernel), MagicCommandTypesFactory.addImport(kernel), MagicCommandTypesFactory.unimport(kernel), MagicCommandTypesFactory.timeLine(kernel), MagicCommandTypesFactory.timeCell(kernel), MagicCommandTypesFactory.timeItLine(kernel), MagicCommandTypesFactory.timeItCell(kernel), MagicCommandTypesFactory.loadMagic(kernel)}));
        return magicCommandTypes;
    }

    private static MagicCommandType loadMagic(KernelFunctionality kernel) {
        return new MagicCommandType("%load_magic", "", new LoadMagicMagicCommand(kernel));
    }

    private static MagicCommandType timeItCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%timeit", "", new TimeItCellModeMagicCommand(kernel));
    }

    private static MagicCommandType timeItLine(KernelFunctionality kernel) {
        return new MagicCommandType("%timeit", "", new TimeItLineModeMagicCommand(kernel));
    }

    private static MagicCommandType timeCell(KernelFunctionality kernel) {
        return new MagicCommandType("%%time", "", new TimeCellModeMagicCommand(kernel));
    }

    private static MagicCommandType timeLine(KernelFunctionality kernel) {
        return new MagicCommandType("%time", "", new TimeLineModeMagicCommand(kernel));
    }

    private static MagicCommandType unimport(KernelFunctionality kernel) {
        return new MagicCommandType("%unimport", "<classpath>", new UnImportMagicCommand(kernel));
    }

    private static MagicCommandType addImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import", "<classpath>", new AddImportMagicCommand(kernel));
    }

    private static MagicCommandType addStaticImport(KernelFunctionality kernel) {
        return new MagicCommandType("%import static", "<classpath>", new AddStaticImportMagicCommand(kernel));
    }

    private static MagicCommandType showClasspath(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath", "", new ClasspathShowMagicCommand(kernel));
    }

    private static MagicCommandType removeJar(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath remove", "<jar path>", new ClasspathRemoveMagicCommand(kernel));
    }

    private static MagicCommandType addJarByMvn(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add mvn", "<group name version>", new ClasspathAddMvnMagicCommand(new MavenJarResolver.ResolverParams(kernel.getTempFolder().toString() + "/../beakerxMvnCache", kernel.getTempFolder().toString() + MavenJarResolver.MVN_DIR), kernel));
    }

    private static MagicCommandType addJar(KernelFunctionality kernel) {
        return new MagicCommandType("%classpath add jar", "<jar path>", new ClasspathAddJarMagicCommand(kernel));
    }

    private static MagicCommandType lsmagic(List<MagicCommandType> magicCommandTypes) {
        return new MagicCommandType("%lsmagic", "", new LsMagicCommand(magicCommandTypes));
    }

    private static MagicCommandType bash() {
        return new MagicCommandType("%%bash", "", new BashMagicCommand());
    }

    private static MagicCommandType html() {
        return new MagicCommandType("%%html", "", new HtmlMagicCommand());
    }

    private static MagicCommandType javascript() {
        return new MagicCommandType("%%javascript", "", new JavaScriptMagicCommand());
    }
}

