/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ControlFlowSubRange
implements ControlFlow {
    private final ControlFlowImpl myControlFlow;
    private final int myStart;
    private final int myEnd;
    private List<Instruction> myInstructions;

    public ControlFlowSubRange(ControlFlowImpl controlFlow, int start, int end) {
        this.myControlFlow = controlFlow;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        if (this.myInstructions == null) {
            ArrayList<Instruction> list2 = new ArrayList<Instruction>(this.myEnd - this.myStart);
            List<Instruction> oldList = this.myControlFlow.getInstructions();
            for (int i = this.myStart; i < this.myEnd; ++i) {
                Instruction instruction = oldList.get(i).clone();
                if (instruction instanceof BranchingInstruction) {
                    BranchingInstruction branchingInstruction = (BranchingInstruction)instruction;
                    branchingInstruction.offset = this.patchOffset(branchingInstruction.offset);
                }
                if (instruction instanceof CallInstruction) {
                    CallInstruction callInstruction = (CallInstruction)instruction;
                    callInstruction.procBegin = this.patchOffset(callInstruction.procBegin);
                    callInstruction.procEnd = this.patchOffset(callInstruction.procEnd);
                }
                if (instruction instanceof ReturnInstruction) {
                    ReturnInstruction returnInstruction = (ReturnInstruction)instruction;
                    CallInstruction callInstruction = new CallInstruction(this.patchOffset(returnInstruction.getProcBegin()), this.patchOffset(returnInstruction.getProcEnd()), returnInstruction.getStack());
                    returnInstruction.setCallInstruction(callInstruction);
                }
                list2.add(instruction);
            }
            this.myInstructions = list2;
        }
        List<Instruction> list3 = this.myInstructions;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowSubRange", "getInstructions"));
        }
        return list3;
    }

    private int patchOffset(int offset2) {
        if (offset2 < this.myStart) {
            offset2 = this.myStart;
        } else if (offset2 > this.myEnd) {
            offset2 = this.myEnd;
        }
        return offset2 -= this.myStart;
    }

    @Override
    public int getSize() {
        return this.myEnd - this.myStart;
    }

    @Override
    public int getStartOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowSubRange", "getStartOffset"));
        }
        return this.patchOffset(this.myControlFlow.getStartOffset(element));
    }

    @Override
    public int getEndOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowSubRange", "getEndOffset"));
        }
        return this.patchOffset(this.myControlFlow.getEndOffset(element));
    }

    @Override
    public PsiElement getElement(int offset2) {
        return this.myControlFlow.getElement(this.myStart + offset2);
    }

    @Override
    public boolean isConstantConditionOccurred() {
        return this.myControlFlow.isConstantConditionOccurred();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CF range:[").append(this.myStart).append("-").append(this.myEnd).append("]\n");
        List<Instruction> instructions = this.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = instructions.get(i);
            buffer.append(Integer.toString(i));
            buffer.append(": ");
            buffer.append(instruction.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

