/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandType;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import java.util.List;
import java.util.stream.Collectors;

public class LsMagicCommand
implements MagicCommandFunctionality {
    public static final String LSMAGIC = "%lsmagic";
    private List<MagicCommandType> magicCommandTypes;

    public LsMagicCommand(List<MagicCommandType> magicCommandTypes) {
        this.magicCommandTypes = magicCommandTypes;
    }

    @Override
    public String getMagicCommandName() {
        return LSMAGIC;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 0 && commandParts[0].equals(LSMAGIC);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String result = "Available magic commands:\n";
        result = result + this.magicCommandTypes.stream().map(commandType -> commandType.getCommand() + " " + commandType.getParameters()).collect(Collectors.joining("\n"));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, result);
    }
}

