/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.message.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class AddImportMagicCommand
implements MagicCommandFunctionality {
    public static final String IMPORT = "%import";
    private KernelFunctionality kernel;

    public AddImportMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    @Override
    public String getMagicCommandName() {
        return IMPORT;
    }

    @Override
    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath(command);
        return commandParts.length > 0 && commandParts[0].equals(IMPORT);
    }

    @Override
    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String command = param.getCommand();
        int executionCount = param.getExecutionCount();
        String[] parts = command.split(" ");
        if (parts.length != 2) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, this.kernel.getImports().toString());
        }
        this.kernel.addImport(new ImportPath(parts[1]));
        if (this.isValidImport(executionCount)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK);
        }
        this.kernel.removeImport(new ImportPath(parts[1]));
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Could not import " + parts[1] + ", class not found.");
    }

    private boolean isValidImport(int executionCount) {
        try {
            CompletableFuture validImportFuture = new CompletableFuture();
            this.kernel.executeCode("", new Message(), executionCount, seo -> validImportFuture.complete(!seo.getStatus().equals((Object)SimpleEvaluationObject.EvaluationStatus.ERROR)));
            return (Boolean)validImportFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return Boolean.FALSE;
        }
    }
}

