/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.xychart.NanoPlot;
import com.twosigma.beakerx.chart.xychart.plotitem.ConstantLine;
import com.twosigma.beakerx.util.SerializerUtil;
import java.io.IOException;

public class ConstantLineSerializer
extends JsonSerializer<ConstantLine> {
    public static final String TYPE = "type";

    public void serialize(ConstantLine constantLine, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        boolean isNanoPlot = NanoPlot.isNanoPlotClass(constantLine.getPlotType());
        jgen.writeObjectField(TYPE, (Object)SerializerUtil.getTypeName(constantLine));
        jgen.writeObjectField("x", isNanoPlot ? this.processLargeNumber(constantLine.getX()) : constantLine.getX());
        jgen.writeObjectField("y", (Object)constantLine.getY());
        jgen.writeObjectField("visible", (Object)constantLine.getVisible());
        jgen.writeObjectField("yAxis", (Object)constantLine.getYAxis());
        jgen.writeObjectField("showLabel", (Object)constantLine.getShowLabel());
        if (constantLine.getWidth() != null) {
            jgen.writeObjectField("width", (Object)constantLine.getWidth());
        }
        if (constantLine.getStyle() != null) {
            jgen.writeObjectField("style", (Object)constantLine.getStyle().toString());
        }
        if (constantLine.getColor() instanceof Color) {
            jgen.writeObjectField("color", (Object)constantLine.getColor());
        }
        jgen.writeEndObject();
    }

    private String processLargeNumber(Number largeNumber) {
        return largeNumber != null ? largeNumber.toString() : "";
    }
}

