/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kotlin.evaluator;

import com.intellij.openapi.util.Disposer;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.kernel.ImportPath;
import com.twosigma.beakerx.kotlin.evaluator.KotlinEvaluator;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplClassLoader;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.repl.ConsoleReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplConfiguration;
import org.jetbrains.kotlin.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.utils.PathUtil;

public class ReplWithClassLoaderFactory {
    @NotNull
    public static ReplWithClassLoader createReplWithClassLoader(KotlinEvaluator kotlinEvaluator) {
        DynamicClassLoaderSimple parent = ReplWithClassLoaderFactory.getParentClassLoader(kotlinEvaluator);
        return ReplWithClassLoaderFactory.createReplInterpreter(ReplWithClassLoaderFactory.getClasspath(), (ClassLoader)parent, kotlinEvaluator);
    }

    @NotNull
    private static String[] getClasspath() {
        String classpath = System.getProperty("java.class.path");
        return classpath.split(File.pathSeparator);
    }

    @NotNull
    private static DynamicClassLoaderSimple getParentClassLoader(KotlinEvaluator kotlinEvaluator) {
        DynamicClassLoaderSimple parent = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        parent.addJars(kotlinEvaluator.getClasspath().getPathsAsStrings());
        parent.addDynamicDir(kotlinEvaluator.getOutDir());
        return parent;
    }

    private static ReplWithClassLoader createReplInterpreter(String[] classpathEntries, ClassLoader parent, KotlinEvaluator kotlinEvaluator) {
        CompilerConfiguration compilerConfiguration = ReplWithClassLoaderFactory.getCompilerConfiguration(classpathEntries);
        ReplInterpreter replInterpreter = new ReplInterpreter(Disposer.newDisposable(), compilerConfiguration, (ReplConfiguration)new ConsoleReplConfiguration());
        ReplClassLoader loader = ReplWithClassLoaderFactory.getReplClassLoader(parent, replInterpreter);
        replInterpreter.eval(ReplWithClassLoaderFactory.getImports(kotlinEvaluator));
        return new ReplWithClassLoader(replInterpreter, loader);
    }

    @NotNull
    private static String getImports(KotlinEvaluator kotlinEvaluator) {
        StringBuilder javaSourceCode = new StringBuilder();
        for (ImportPath i : kotlinEvaluator.getImports().getImportPaths()) {
            javaSourceCode.append("import ");
            javaSourceCode.append(ReplWithClassLoaderFactory.adjustImport(i));
            javaSourceCode.append("\n");
        }
        return javaSourceCode.toString();
    }

    @NotNull
    private static ReplClassLoader getReplClassLoader(ClassLoader parent, ReplInterpreter replInterpreter) {
        ReplClassLoader loader = null;
        try {
            loader = new ReplClassLoader(parent);
            Field classLoader = replInterpreter.getClass().getDeclaredField("classLoader");
            classLoader.setAccessible(true);
            classLoader.set(replInterpreter, loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loader;
    }

    @NotNull
    private static CompilerConfiguration getCompilerConfiguration(String[] classpathEntries) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CommonConfigurationKeys.MODULE_NAME, (Object)("kotlinModule" + System.currentTimeMillis()));
        compilerConfiguration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, (Object)true);
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)compilerConfiguration, (List)PathUtil.getJdkClassesRootsFromCurrentJre());
        Arrays.stream(classpathEntries).forEach(x -> JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)new File((String)x)));
        return compilerConfiguration;
    }

    private static String adjustImport(ImportPath importPath) {
        String currentImportPath = importPath.asString();
        if (currentImportPath.startsWith("import")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.startsWith("static")) {
            currentImportPath = currentImportPath.substring(6).trim();
        }
        if (currentImportPath.contains(".object.")) {
            currentImportPath = currentImportPath.replace(".object.", ".`object`.");
        }
        return currentImportPath;
    }

    public static class ReplWithClassLoader {
        private ReplClassLoader loader;
        private ReplInterpreter repl;

        public ReplWithClassLoader(ReplInterpreter repl, ReplClassLoader loader) {
            this.loader = loader;
            this.repl = repl;
        }

        public ReplClassLoader getLoader() {
            return this.loader;
        }

        public ReplInterpreter getRepl() {
            return this.repl;
        }
    }
}

