/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.InOperationTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final KtWhenExpression whenExpression;
    @Nullable
    private final JsExpression expressionToMatch;

    @Nullable
    public static JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            WhenTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(1);
        }
        return new WhenTranslator(expression2, context).translate();
    }

    private WhenTranslator(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            WhenTranslator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(3);
        }
        super(context);
        this.whenExpression = expression2;
        KtExpression subject = expression2.getSubjectExpression();
        this.expressionToMatch = subject != null ? context.defineTemporary(Translation.translateAsExpression(subject, context)) : null;
    }

    private JsNode translate() {
        JsIf currentIf = null;
        SourceInfoAwareJsNode resultIf = null;
        for (KtWhenEntry entry : this.whenExpression.getEntries()) {
            JsBlock statementBlock = new JsBlock();
            JsStatement statement2 = WhenTranslator.translateEntryExpression(entry, this.context(), statementBlock);
            if (resultIf == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement2;
            }
            statement2 = JsAstUtils.mergeStatementInBlockIfNeeded(statement2, statementBlock);
            if (resultIf == null) {
                currentIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context()), statement2);
                resultIf = currentIf;
                continue;
            }
            if (entry.isElse()) {
                currentIf.setElseStatement(statement2);
                return resultIf;
            }
            JsBlock conditionsBlock = new JsBlock();
            JsIf nextIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context().innerBlock(conditionsBlock)), statement2);
            JsStatement statementToAdd = JsAstUtils.mergeStatementInBlockIfNeeded(nextIf, conditionsBlock);
            currentIf.setElseStatement(statementToAdd);
            currentIf = nextIf;
        }
        if (currentIf != null && currentIf.getElseStatement() == null && this.isExhaustive()) {
            JsInvocation noWhenMatchedInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("noWhenBranchMatched", (JsExpression)Namer.kotlinObject()), new JsExpression[0]);
            currentIf.setElseStatement(JsAstUtils.asSyntheticStatement(noWhenMatchedInvocation));
        }
        return resultIf != null ? resultIf : JsLiteral.NULL;
    }

    private boolean isExhaustive() {
        KotlinType type2 = this.bindingContext().getType(this.whenExpression);
        boolean isStatement = type2 != null && KotlinBuiltIns.isUnit(type2) && !type2.isMarkedNullable();
        return CodegenUtil.isExhaustive(this.bindingContext(), this.whenExpression, isStatement);
    }

    @NotNull
    private static JsStatement translateEntryExpression(@NotNull KtWhenEntry entry, @NotNull TranslationContext context, @NotNull JsBlock block) {
        if (entry == null) {
            WhenTranslator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(5);
        }
        if (block == null) {
            WhenTranslator.$$$reportNull$$$0(6);
        }
        KtExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        JsStatement jsStatement = Translation.translateAsStatement(expressionToExecute, context, block);
        if (jsStatement == null) {
            WhenTranslator.$$$reportNull$$$0(7);
        }
        return jsStatement;
    }

    @NotNull
    private JsExpression translateConditions(@NotNull KtWhenEntry entry, @NotNull TranslationContext context) {
        if (entry == null) {
            WhenTranslator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(9);
        }
        KtWhenCondition[] conditions2 = entry.getConditions();
        assert (conditions2.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions2.length == 1) {
            JsExpression jsExpression = this.translateCondition(conditions2[0], context);
            if (jsExpression == null) {
                WhenTranslator.$$$reportNull$$$0(10);
            }
            return jsExpression;
        }
        JsExpression result2 = this.translateCondition(conditions2[0], context);
        for (int i = 1; i < conditions2.length; ++i) {
            result2 = this.translateOrCondition(result2, conditions2[i], context);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            WhenTranslator.$$$reportNull$$$0(11);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateOrCondition(@NotNull JsExpression leftExpression, @NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (leftExpression == null) {
            WhenTranslator.$$$reportNull$$$0(12);
        }
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(13);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(14);
        }
        TranslationContext rightContext = context.innerBlock();
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                WhenTranslator.$$$reportNull$$$0(15);
            }
            return jsBinaryOperation;
        }
        assert (rightExpression instanceof JsNameRef) : "expected JsNameRef, but: " + rightExpression;
        JsNameRef result2 = (JsNameRef)rightExpression;
        JsIf ifStatement = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, JsLiteral.TRUE).makeStmt(), rightContext.getCurrentBlock());
        context.addStatementToCurrentBlock(ifStatement);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            WhenTranslator.$$$reportNull$$$0(16);
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(17);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(18);
        }
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context);
        if (WhenTranslator.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(patternMatchExpression);
            if (jsPrefixOperation == null) {
                WhenTranslator.$$$reportNull$$$0(19);
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = patternMatchExpression;
        if (jsExpression == null) {
            WhenTranslator.$$$reportNull$$$0(20);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(22);
        }
        if (condition instanceof KtWhenConditionIsPattern) {
            JsExpression jsExpression = this.translateIsCondition((KtWhenConditionIsPattern)condition, context);
            if (jsExpression == null) {
                WhenTranslator.$$$reportNull$$$0(23);
            }
            return jsExpression;
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            JsExpression jsExpression = this.translateExpressionCondition((KtWhenConditionWithExpression)condition, context);
            if (jsExpression == null) {
                WhenTranslator.$$$reportNull$$$0(24);
            }
            return jsExpression;
        }
        if (condition instanceof KtWhenConditionInRange) {
            JsExpression jsExpression = this.translateRangeCondition((KtWhenConditionInRange)condition, context);
            if (jsExpression == null) {
                WhenTranslator.$$$reportNull$$$0(25);
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull KtWhenConditionIsPattern conditionIsPattern, @NotNull TranslationContext context) {
        if (conditionIsPattern == null) {
            WhenTranslator.$$$reportNull$$$0(26);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(27);
        }
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        KtTypeReference typeReference = conditionIsPattern.getTypeReference();
        assert (typeReference != null) : "An is-check must have a type reference.";
        KtExpression expressionToMatchNonTranslated = this.whenExpression.getSubjectExpression();
        assert (expressionToMatchNonTranslated != null) : "expressionToMatch != null => expressionToMatchNonTranslated != null: " + PsiUtilsKt.getTextWithLocation(conditionIsPattern);
        JsExpression result2 = Translation.patternTranslator(context).translateIsCheck(expressionToMatch, typeReference);
        JsExpression jsExpression = result2 != null ? result2 : JsLiteral.TRUE;
        if (jsExpression == null) {
            WhenTranslator.$$$reportNull$$$0(28);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull KtWhenConditionWithExpression condition, @NotNull TranslationContext context) {
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(29);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(30);
        }
        KtExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            JsExpression jsExpression = Translation.patternTranslator(context).translateExpressionForExpressionPattern(patternExpression);
            if (jsExpression == null) {
                WhenTranslator.$$$reportNull$$$0(31);
            }
            return jsExpression;
        }
        KtExpression subject = this.whenExpression.getSubjectExpression();
        assert (subject != null) : "Subject must be non-null since expressionToMatch is non-null: " + PsiUtilsKt.getTextWithLocation(condition);
        KotlinType type2 = BindingUtils.getTypeForExpression(this.bindingContext(), this.whenExpression.getSubjectExpression());
        JsExpression jsExpression = Translation.patternTranslator(context).translateExpressionPattern(type2, expressionToMatch, patternExpression);
        if (jsExpression == null) {
            WhenTranslator.$$$reportNull$$$0(32);
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateRangeCondition(@NotNull KtWhenConditionInRange condition, @NotNull TranslationContext context) {
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(33);
        }
        if (context == null) {
            WhenTranslator.$$$reportNull$$$0(34);
        }
        KtExpression patternExpression = condition.getRangeExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression: " + PsiUtilsKt.getTextWithLocation(condition);
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "Range pattern is only available for 'when (C) { in ... }'  expressions: " + PsiUtilsKt.getTextWithLocation(condition);
        HashMap<KtExpression, JsExpression> subjectAliases = new HashMap<KtExpression, JsExpression>();
        subjectAliases.put(this.whenExpression.getSubjectExpression(), expressionToMatch);
        TranslationContext callContext = context.innerContextWithAliasesForExpressions(subjectAliases);
        boolean negated = condition.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IN;
        JsExpression jsExpression = new InOperationTranslator(callContext, expressionToMatch, condition.getRangeExpression(), condition.getOperationReference(), negated).translate();
        if (jsExpression == null) {
            WhenTranslator.$$$reportNull$$$0(35);
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch;
    }

    private static boolean isNegated(@NotNull KtWhenCondition condition) {
        if (condition == null) {
            WhenTranslator.$$$reportNull$$$0(36);
        }
        if (condition instanceof KtWhenConditionIsPattern) {
            return ((KtWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 14: 
            case 18: 
            case 22: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/expression/WhenTranslator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionIsPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/expression/WhenTranslator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateEntryExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "translateConditions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "translateOrCondition";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "translateCondition";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "translateWhenConditionToBooleanExpression";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "translateIsCondition";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpressionCondition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "translateRangeCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateEntryExpression";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "translateConditions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "translateOrCondition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "translateCondition";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "translateWhenConditionToBooleanExpression";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "translateIsCondition";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "translateExpressionCondition";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "translateRangeCondition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isNegated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

