/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.coroutine;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutineFunctionTransformer;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u000fH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u000fH\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/coroutine/CoroutineTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;)V", "additionalStatementsByNode", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "endVisit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "kotlin-compiler"})
public final class CoroutineTransformer
extends JsVisitorWithContextImpl {
    private final Map<JsNode, List<JsStatement>> additionalStatementsByNode;
    private final JsProgram program;

    public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        List<JsStatement> list2 = this.additionalStatementsByNode.remove(x);
        if (list2 != null) {
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                JsStatement it = (JsStatement)element$iv;
                ctx.addNext((JsNode)it);
            }
        }
        super.endVisit(x, ctx);
    }

    public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        for (JsVars.JsVar v : x.getVars()) {
            List<JsStatement> list2 = this.additionalStatementsByNode.remove(v);
            if (list2 == null) continue;
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                JsStatement it = (JsStatement)element$iv;
                ctx.addNext((JsNode)it);
            }
        }
        super.endVisit(x, ctx);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression expression2 = x.getExpression();
        Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(expression2);
        if (assignment != null) {
            JsFunction function2;
            JsFunction jsFunction;
            void rhs;
            Pair<JsExpression, JsExpression> pair = assignment;
            JsExpression jsExpression = pair.component1();
            JsExpression jsExpression2 = pair.component2();
            pair = null;
            Object v0 = rhs;
            if (!(v0 instanceof JsFunction)) {
                v0 = null;
            }
            if ((jsFunction = (JsFunction)v0) == null) {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose((JsExpression)rhs);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            JsFunction jsFunction2 = function2 = jsFunction;
            if ((jsFunction2 != null ? MetadataProperties.getCoroutineMetadata(jsFunction2) : null) != null) {
                HasMetadata hasMetadata;
                void lhs;
                Object v4 = lhs;
                if (!(v4 instanceof JsNameRef)) {
                    v4 = null;
                }
                if ((hasMetadata = (JsNameRef)v4) == null || (hasMetadata = ((JsNameRef)hasMetadata).getName()) == null) {
                    hasMetadata = function2.getName();
                }
                String name = hasMetadata != null ? ((JsName)hasMetadata).getIdent() : null;
                Map<JsNode, List<JsStatement>> map2 = this.additionalStatementsByNode;
                List<JsStatement> list2 = new CoroutineFunctionTransformer(this.program, function2, name).transform();
                map2.put(x, list2);
                return false;
            }
        } else if (expression2 instanceof JsFunction && MetadataProperties.getCoroutineMetadata((JsFunction)expression2) != null) {
            Map<JsNode, List<JsStatement>> map3 = this.additionalStatementsByNode;
            JsExpression jsExpression = expression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "expression");
            JsName jsName = ((JsFunction)expression2).getName();
            List<JsStatement> list3 = new CoroutineFunctionTransformer(this.program, (JsFunction)jsExpression, jsName != null ? jsName.getIdent() : null).transform();
            map3.put(x, list3);
            return false;
        }
        return super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        JsExpression initExpression = x.getInitExpression();
        if (initExpression != null) {
            JsFunction function2;
            JsFunction jsFunction;
            JsExpression jsExpression = initExpression;
            if (!(jsExpression instanceof JsFunction)) {
                jsExpression = null;
            }
            if ((jsFunction = (JsFunction)jsExpression) == null) {
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(initExpression);
                jsFunction = inlineMetadata != null ? inlineMetadata.getFunction() : null;
            }
            JsFunction jsFunction2 = function2 = jsFunction;
            if ((jsFunction2 != null ? MetadataProperties.getCoroutineMetadata(jsFunction2) : null) != null) {
                String name = x.getName().getIdent();
                Map<JsNode, List<JsStatement>> map2 = this.additionalStatementsByNode;
                List<JsStatement> list2 = new CoroutineFunctionTransformer(this.program, function2, name).transform();
                map2.put(x, list2);
                return false;
            }
        }
        return super.visit(x, ctx);
    }

    public CoroutineTransformer(@NotNull JsProgram program) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(program, "program");
        this.program = program;
        CoroutineTransformer coroutineTransformer = this;
        coroutineTransformer.additionalStatementsByNode = map2 = (Map)new LinkedHashMap();
    }
}

