/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import com.twosigma.beakerx.clojure.evaluator.ClojureCodeRunner;
import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClojureWorkerThread
extends WorkerThread {
    private static final Logger logger = LoggerFactory.getLogger((String)ClojureWorkerThread.class.getName());
    private ClojureEvaluator clojureEvaluator;
    private boolean exit;

    ClojureWorkerThread(ClojureEvaluator clojureEvaluator) {
        super("clojure worker");
        this.clojureEvaluator = clojureEvaluator;
        this.exit = false;
    }

    public void run() {
        JobDescriptor j = null;
        while (!this.exit) {
            try {
                this.syncObject.acquire();
                j = (JobDescriptor)this.jobQueue.poll();
                if (j == null) continue;
                j.outputObject.started();
                if (this.clojureEvaluator.executeTask(new ClojureCodeRunner(this.clojureEvaluator, j.codeToBeExecuted, j.outputObject))) continue;
                j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
            catch (Throwable e) {
                logger.error(e.getMessage());
            }
            finally {
                if (j == null || j.outputObject == null) continue;
                j.outputObject.executeCodeCallback();
            }
        }
    }

    void doExit() {
        this.exit = true;
    }
}

