/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.clojure.evaluator;

import com.twosigma.beakerx.clojure.evaluator.ClojureEvaluator;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

class ClojureCodeRunner
implements Runnable {
    private ClojureEvaluator clojureEvaluator;
    private final String theCode;
    private final SimpleEvaluationObject theOutput;

    ClojureCodeRunner(ClojureEvaluator clojureEvaluator, String code, SimpleEvaluationObject out) {
        this.clojureEvaluator = clojureEvaluator;
        this.theCode = code;
        this.theOutput = out;
    }

    @Override
    public void run() {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.clojureEvaluator.getLoader());
        this.theOutput.setOutputHandler();
        try {
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            Object o = this.clojureEvaluator.runCode(this.theCode);
            try {
                this.checkingOfCorruptedClojureObjects(o);
                this.theOutput.finished(o);
            }
            catch (Exception e) {
                this.theOutput.error((Object)("Object: " + o.getClass() + ", value cannot be displayed due to following error: " + e.getMessage()));
            }
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (null != e.getCause()) {
                e.getCause().printStackTrace(pw);
            } else {
                e.printStackTrace(pw);
            }
            this.theOutput.error((Object)sw.toString());
        }
        this.theOutput.setOutputHandler();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    private void checkingOfCorruptedClojureObjects(Object o) {
        if (null != o) {
            o.hashCode();
        }
    }
}

