/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.commands;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.kernel.commands.MavenInvocationSilentOutputHandler;
import com.twosigma.beakerx.kernel.commands.MavenJarResolverSilentLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;

public class MavenJarResolver {
    public static final String MVN_DIR = File.separator + "mvnJars";
    public static final String POM_XML = "PomTemplateMagicCommand.xml";
    public static final List<String> GOALS = Arrays.asList("validate");
    private final String pathToMavenRepo;
    private ResolverParams commandParams;
    private String mavenLocation;

    public MavenJarResolver(ResolverParams commandParams) {
        this.commandParams = (ResolverParams)Preconditions.checkNotNull((Object)commandParams);
        this.pathToMavenRepo = this.getOrCreateFile(commandParams.getPathToNotebookJars()).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddMvnCommandResult retrieve(String groupId, String artifactId, String version) {
        File finalPom = null;
        try {
            finalPom = this.getPom(groupId, artifactId, version);
            InvocationRequest request = this.createInvocationRequest();
            request.setOffline(this.commandParams.getOffline());
            request.setPomFile(finalPom);
            Invoker invoker = this.getInvoker();
            InvocationResult invocationResult = invoker.execute(request);
            AddMvnCommandResult addMvnCommandResult = this.getResult(invocationResult, groupId, artifactId, version);
            this.deletePomFolder(finalPom);
            return addMvnCommandResult;
        }
        catch (Exception e) {
            try {
                AddMvnCommandResult addMvnCommandResult = AddMvnCommandResult.error(e.getMessage());
                this.deletePomFolder(finalPom);
                return addMvnCommandResult;
            }
            catch (Throwable throwable) {
                this.deletePomFolder(finalPom);
                throw throwable;
            }
        }
    }

    private Invoker getInvoker() {
        DefaultInvoker invoker = new DefaultInvoker();
        String mvn = this.findMvn();
        System.setProperty("maven.home", mvn);
        invoker.setLogger((InvokerLogger)new MavenJarResolverSilentLogger());
        invoker.setOutputHandler((InvocationOutputHandler)new MavenInvocationSilentOutputHandler());
        invoker.setLocalRepositoryDirectory(this.getOrCreateFile(this.commandParams.getPathToCache()));
        return invoker;
    }

    public String findMvn() {
        if (this.mavenLocation == null) {
            if (System.getenv("M2_HOME") != null) {
                this.mavenLocation = System.getenv("M2_HOME") + "/bin/mvn";
                return this.mavenLocation;
            }
            for (String dirname : System.getenv("PATH").split(File.pathSeparator)) {
                File file = new File(dirname, "mvn");
                if (!file.isFile() || !file.canExecute()) continue;
                this.mavenLocation = file.getAbsolutePath();
                return this.mavenLocation;
            }
            throw new RuntimeException("No mvn found, please install mvn by 'conda install maven' or setup M2_HOME");
        }
        return this.mavenLocation;
    }

    private AddMvnCommandResult getResult(InvocationResult invocationResult, String groupId, String artifactId, String version) {
        if (invocationResult.getExitCode() != 0) {
            if (invocationResult.getExecutionException() != null) {
                return AddMvnCommandResult.error(invocationResult.getExecutionException().getMessage());
            }
            return AddMvnCommandResult.error("Could not resolve dependencies for: " + groupId + " : " + artifactId + " : " + version);
        }
        return AddMvnCommandResult.SUCCESS;
    }

    private InvocationRequest createInvocationRequest() {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(GOALS);
        return request;
    }

    private void deletePomFolder(File finalPom) {
        if (finalPom != null) {
            File parentFile = new File(finalPom.getParent());
            try {
                FileUtils.deleteDirectory((File)parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File getPom(String groupId, String artifactId, String version) throws IOException {
        InputStream pom = this.getClass().getClassLoader().getResourceAsStream(POM_XML);
        String pomAsString = IOUtils.toString((InputStream)pom, (Charset)StandardCharsets.UTF_8);
        pomAsString = this.configureOutputDir(pomAsString);
        pomAsString = this.configureDependencies(groupId, artifactId, version, pomAsString);
        File finalPom = new File(this.commandParams.getPathToNotebookJars() + "/poms/pom-" + UUID.randomUUID() + "-" + groupId + artifactId + version + "xml");
        FileUtils.writeStringToFile((File)finalPom, (String)pomAsString, (Charset)StandardCharsets.UTF_8);
        return finalPom;
    }

    private String configureDependencies(String groupId, String artifactId, String version, String pomAsString) {
        return pomAsString.replace("<dependencies></dependencies>", "<dependencies>\n  <dependency>\n    <groupId>" + groupId + "</groupId>\n    <artifactId>" + artifactId + "</artifactId>\n    <version>" + version + "</version>\n  </dependency>\n</dependencies>");
    }

    private String configureOutputDir(String pomAsString) {
        String absolutePath = new File(this.getPathToMavenRepo()).getAbsolutePath();
        return pomAsString.replace("<outputDirectory>pathToNotebookJars</outputDirectory>", "<outputDirectory>" + absolutePath + "</outputDirectory>");
    }

    public String getPathToMavenRepo() {
        return this.pathToMavenRepo;
    }

    private File getOrCreateFile(String pathToMavenRepo) {
        File theDir = new File(pathToMavenRepo);
        if (!theDir.exists()) {
            try {
                theDir.mkdir();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return theDir;
    }

    public static class ResolverParams {
        private String pathToCache;
        private String pathToNotebookJars;
        private boolean offline = false;

        public ResolverParams(String pathToCache, String pathToNotebookJars, boolean offline) {
            this.pathToCache = (String)Preconditions.checkNotNull((Object)pathToCache);
            this.pathToNotebookJars = (String)Preconditions.checkNotNull((Object)pathToNotebookJars);
            this.offline = offline;
        }

        public ResolverParams(String pathToCache, String pathToNotebookJars) {
            this(pathToCache, pathToNotebookJars, false);
        }

        public String getPathToCache() {
            return this.pathToCache;
        }

        public String getPathToNotebookJars() {
            return this.pathToNotebookJars;
        }

        public boolean getOffline() {
            return this.offline;
        }
    }

    public static class AddMvnCommandResult {
        public static final AddMvnCommandResult SUCCESS = new AddMvnCommandResult(true, "");
        private boolean jarRetrieved;
        private String errorMessage;

        private AddMvnCommandResult(boolean retrieved, String errorMessage) {
            this.jarRetrieved = retrieved;
            this.errorMessage = errorMessage;
        }

        public boolean isJarRetrieved() {
            return this.jarRetrieved;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static AddMvnCommandResult success() {
            return SUCCESS;
        }

        public static AddMvnCommandResult error(String msg) {
            return new AddMvnCommandResult(false, msg);
        }
    }
}

