/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel;

import com.google.common.base.Preconditions;
import com.twosigma.beakerx.kernel.ImportPath;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Imports {
    private List<ImportPath> imports = new ArrayList<ImportPath>();
    private List<String> importsAsStrings = null;

    public List<ImportPath> getImportPaths() {
        return this.imports;
    }

    public boolean add(ImportPath anImport) {
        Preconditions.checkNotNull((Object)anImport);
        if (!this.imports.contains(anImport)) {
            this.clear();
            return this.imports.add(anImport);
        }
        return false;
    }

    public boolean remove(ImportPath anImport) {
        Preconditions.checkNotNull((Object)anImport);
        if (this.imports.contains(anImport)) {
            this.clear();
            return this.imports.remove(anImport);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }

    public List<String> toListOfStrings() {
        if (this.importsAsStrings == null) {
            this.importsAsStrings = this.importsToStrings();
        }
        return this.importsAsStrings;
    }

    private List<String> importsToStrings() {
        ArrayList<String> importsAsStrings = new ArrayList<String>();
        for (ImportPath st : this.getImportPaths()) {
            importsAsStrings.add(st.asString());
        }
        return importsAsStrings;
    }

    private void clear() {
        this.importsAsStrings = null;
    }

    public String toString() {
        return this.imports.stream().map(ImportPath::asString).collect(Collectors.joining("\n"));
    }
}

