/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.xychart.plotitem.Rasters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class RastersSerializer
extends JsonSerializer<Rasters> {
    public static final String TYPE = "type";

    public void serialize(Rasters rasters, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        this.validate(rasters);
        jgen.writeStartObject();
        jgen.writeObjectField(TYPE, (Object)rasters.getClass().getSimpleName());
        jgen.writeObjectField("x", rasters.getX());
        jgen.writeObjectField("y", rasters.getY());
        jgen.writeObjectField("opacity", rasters.getOpacity());
        jgen.writeObjectField("visible", (Object)rasters.getVisible());
        jgen.writeObjectField("yAxis", (Object)rasters.getYAxis());
        jgen.writeObjectField("position", (Object)rasters.getPosition());
        jgen.writeObjectField("width", rasters.getWidth());
        jgen.writeObjectField("height", rasters.getHeight());
        if (rasters.getDataString() != null) {
            jgen.writeObjectField("value", (Object)this.Bytes2Base64(rasters.getDataString(), null));
        } else if (!rasters.getFilePath().isEmpty()) {
            String path = rasters.getFilePath();
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot find file " + path);
            }
            byte[] picture = Files.readAllBytes(new File(path).toPath());
            String extension = "";
            int i = path.lastIndexOf(46);
            if (i > 0) {
                extension = path.substring(i + 1);
            }
            jgen.writeObjectField("value", (Object)this.Bytes2Base64(picture, extension));
        } else if (!rasters.getFileUrl().isEmpty()) {
            jgen.writeObjectField("value", (Object)rasters.getFileUrl());
        }
        jgen.writeEndObject();
    }

    private void validate(Rasters raster) {
        if (raster.getY() == null || raster.getY().isEmpty()) {
            throw new IllegalStateException("Please provide Y coordinate");
        }
        if (raster.getHeight() == null || raster.getHeight().isEmpty()) {
            throw new IllegalStateException("Please provide height size.");
        }
        if (raster.getWidth() == null || raster.getWidth().isEmpty()) {
            throw new IllegalStateException("Please provide width size.");
        }
    }

    private String Bytes2Base64(byte[] bytes, String format) {
        StringBuilder sb = new StringBuilder();
        if (format != null) {
            sb.append("data:image/").append(format).append(";base64,");
        } else {
            sb.append("data:image/png;base64,");
        }
        sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])bytes, (boolean)false)));
        return sb.toString();
    }
}

