/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.categoryplot.plotitem;

import com.twosigma.beakerx.chart.ChartUtils;
import com.twosigma.beakerx.chart.Color;
import com.twosigma.beakerx.chart.Graphics;
import com.twosigma.beakerx.chart.categoryplot.CategoryPlot;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public abstract class CategoryGraphics
extends Graphics {
    protected Number[][] value;
    protected List<String> seriesNames;
    protected Color baseColor;
    private List<Object> colors;
    private Object itemLabelBuilder;
    private String[][] itemLabels;
    private boolean showItemLabel = false;
    private boolean centerSeries = false;
    private boolean useToolTip = true;

    protected List<Number> getBases() {
        return null;
    }

    protected Number getBase() {
        return null;
    }

    public void createItemLabels(CategoryPlot plot) {
        if (this.itemLabelBuilder == null || this.value == null) {
            this.itemLabels = null;
            return;
        }
        int itemCategoriesNumber = this.value[0].length;
        int itemSeriesNumber = this.value.length;
        String[][] itemLabels = new String[itemCategoriesNumber][itemSeriesNumber];
        try {
            Class<?> clazz = this.itemLabelBuilder.getClass();
            Method getMaximumNumberOfParameters = clazz.getMethod("getMaximumNumberOfParameters", new Class[0]);
            getMaximumNumberOfParameters.setAccessible(true);
            int numberOfParameters = (Integer)getMaximumNumberOfParameters.invoke(this.itemLabelBuilder, new Object[0]);
            for (int column = 0; column < itemCategoriesNumber; ++column) {
                List<String> categoryNames = plot.getCategoryNames();
                String category = categoryNames != null && categoryNames.size() > column ? categoryNames.get(column) : null;
                for (int row = 0; row < itemSeriesNumber; ++row) {
                    Number base;
                    Method call;
                    String series;
                    Number _value = this.value[row][column];
                    String string = series = this.seriesNames != null && this.seriesNames.size() > row ? this.seriesNames.get(row) : null;
                    if (numberOfParameters == 1) {
                        call = clazz.getMethod("call", Object.class);
                        call.setAccessible(true);
                        itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value));
                        continue;
                    }
                    Object object = this.getBases() != null ? (this.getBases().get(row) instanceof List ? ((List)((Object)this.getBases().get(row))).get(column) : this.getBases().get(row)) : (base = this.getBase());
                    if (numberOfParameters == 2) {
                        call = clazz.getMethod("call", Object.class, Object.class);
                        call.setAccessible(true);
                        itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value, base));
                        continue;
                    }
                    if (numberOfParameters == 3) {
                        call = clazz.getMethod("call", Object.class, Object.class, Object.class);
                        call.setAccessible(true);
                        itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value, base, series));
                        continue;
                    }
                    if (numberOfParameters == 4) {
                        call = clazz.getMethod("call", Object.class, Object.class, Object.class, Object.class);
                        call.setAccessible(true);
                        itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value, base, series, category));
                        continue;
                    }
                    if (numberOfParameters == 5) {
                        call = clazz.getMethod("call", Object.class, Object.class, Object.class, Object.class, Object.class);
                        call.setAccessible(true);
                        itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value, base, series, category, row));
                        continue;
                    }
                    if (numberOfParameters != 6) continue;
                    call = clazz.getMethod("call", Object.class, Object.class, Object.class, Object.class, Object.class, Object.class);
                    call.setAccessible(true);
                    itemLabels[column][row] = String.valueOf(call.invoke(this.itemLabelBuilder, _value, base, series, category, row, column));
                }
            }
        }
        catch (Throwable x) {
            throw new RuntimeException("Can not create item labels.", x);
        }
        this.itemLabels = itemLabels;
    }

    public String[][] getItemLabels() {
        return this.itemLabels;
    }

    public void setItemLabel(Object itemLabel) {
        this.itemLabelBuilder = itemLabel;
    }

    public void setColor(Color color) {
        this.baseColor = color;
    }

    public void setColor(java.awt.Color color) {
        this.setColor(new Color(color));
    }

    public void setColor(List<Object> colorList) {
        this.setColors(colorList);
    }

    private void setColors(List<Object> colorList) {
        this.colors = colorList != null ? ChartUtils.convertColors(colorList, "setColor takes Color or List of Color") : null;
    }

    public List<Object> getColors() {
        return this.colors;
    }

    @Override
    public void setColori(Color color) {
        this.baseColor = color;
    }

    @Override
    public Color getColor() {
        return this.baseColor;
    }

    public Number[][] getValue() {
        return this.value;
    }

    public void setValue(Object[] value) {
        if (value != null && ArrayUtils.isNotEmpty((Object[])value)) {
            if (value[0] instanceof List) {
                this.value = new Number[value.length][];
                for (int i = 0; i < value.length; ++i) {
                    List a = (List)value[i];
                    this.value[i] = a.toArray(new Number[a.size()]);
                }
            } else {
                this.value = new Number[][]{(Number[])Arrays.copyOf(value, value.length, Number[].class)};
            }
        }
    }

    public List<String> getSeriesNames() {
        return this.seriesNames;
    }

    public void setSeriesNames(List<String> seriesNames) {
        this.seriesNames = seriesNames;
    }

    public boolean getShowItemLabel() {
        return this.showItemLabel;
    }

    public void setShowItemLabel(boolean showItemLabel) {
        this.showItemLabel = showItemLabel;
    }

    public boolean getCenterSeries() {
        return this.centerSeries;
    }

    public void setCenterSeries(boolean centerSeries) {
        this.centerSeries = centerSeries;
    }

    public void setUseToolTip(boolean useToolTip) {
        this.useToolTip = useToolTip;
    }

    public Boolean getUseToolTip() {
        return this.useToolTip;
    }
}

