/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.groovy.evaluator.GroovyEvaluator;
import com.twosigma.beakerx.groovy.evaluator.GroovyWorkerThread;
import com.twosigma.beakerx.jvm.object.SimpleEvaluationObject;
import groovy.lang.Script;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GroovyCodeRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyCodeRunner.class.getName());
    private GroovyWorkerThread groovyWorkerThread;
    private final String theCode;
    private final SimpleEvaluationObject theOutput;

    public GroovyCodeRunner(GroovyWorkerThread groovyWorkerThread, String code, SimpleEvaluationObject out) {
        this.groovyWorkerThread = groovyWorkerThread;
        this.theCode = code;
        this.theOutput = out;
    }

    @Override
    public void run() {
        ClassLoader oldld = Thread.currentThread().getContextClassLoader();
        this.theOutput.setOutputHandler();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.groovyWorkerThread.getGroovyClassLoader());
            Class parsedClass = this.groovyWorkerThread.getGroovyClassLoader().parseClass(this.theCode);
            Script instance = (Script)parsedClass.newInstance();
            if (GroovyEvaluator.LOCAL_DEV) {
                this.groovyWorkerThread.getScriptBinding().setVariable("beakerx", new HashMap());
            } else {
                this.groovyWorkerThread.getScriptBinding().setVariable("beakerx", (Object)NamespaceClient.getBeaker((String)this.groovyWorkerThread.groovyEvaluator.getSessionId()));
            }
            instance.setBinding(this.groovyWorkerThread.getScriptBinding());
            InternalVariable.setValue((SimpleEvaluationObject)this.theOutput);
            Object result = instance.run();
            if (GroovyEvaluator.LOCAL_DEV) {
                logger.info("Result: {}", result);
                logger.info("Variables: {}", (Object)this.groovyWorkerThread.getScriptBinding().getVariables());
            }
            this.theOutput.finished(result);
        }
        catch (Throwable e) {
            if (GroovyEvaluator.LOCAL_DEV) {
                logger.warn(e.getMessage());
                e.printStackTrace();
            }
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if (e instanceof InterruptedException || e instanceof InvocationTargetException || e instanceof ThreadDeath) {
                this.theOutput.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            StackTraceUtils.sanitize((Throwable)e).printStackTrace(pw);
            this.theOutput.error((Object)sw.toString());
        }
        this.theOutput.clrOutputHandler();
        Thread.currentThread().setContextClassLoader(oldld);
    }
}

