/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.sql.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.sql.evaluator.SQLCodeRunner;
import com.twosigma.beakerx.sql.evaluator.SQLEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SQLWorkerThread
extends WorkerThread {
    private static final Logger logger = LoggerFactory.getLogger((String)SQLWorkerThread.class.getName());
    private SQLEvaluator sqlEvaluator;
    protected volatile boolean exit;

    SQLWorkerThread(SQLEvaluator sqlEvaluator) {
        super("sql worker");
        this.sqlEvaluator = sqlEvaluator;
    }

    public void run() {
        while (!this.exit) {
            try {
                this.syncObject.acquire();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
            if (this.exit) break;
            JobDescriptor job = (JobDescriptor)this.jobQueue.poll();
            job.getSimpleEvaluationObject().started();
            job.getSimpleEvaluationObject().setOutputHandler();
            NamespaceClient namespaceClient = NamespaceClient.getBeaker((String)this.sqlEvaluator.getSessionId());
            namespaceClient.setOutputObj(job.getSimpleEvaluationObject());
            this.sqlEvaluator.executeTask(new SQLCodeRunner(this.sqlEvaluator, job.getSimpleEvaluationObject(), namespaceClient));
            job.getSimpleEvaluationObject().clrOutputHandler();
            namespaceClient.setOutputObj(null);
            if (job == null || job.getSimpleEvaluationObject() == null) continue;
            job.getSimpleEvaluationObject().executeCodeCallback();
        }
    }

    public void doExit() {
        this.exit = true;
    }
}

