/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.AstPath;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AstPathPsiMap {
    private final ConcurrentMap<AstPath, MyReference> myMap;
    private static final Key<MyReferenceQueue> STUB_PSI_REFS = Key.create("STUB_PSI_REFS");
    private final MyReferenceQueue myQueue;

    AstPathPsiMap(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/AstPathPsiMap", "<init>"));
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        MyReferenceQueue queue = project.getUserData(STUB_PSI_REFS);
        this.myQueue = queue != null ? queue : ((UserDataHolderEx)((Object)project)).putUserDataIfAbsent(STUB_PSI_REFS, new MyReferenceQueue(project));
    }

    void invalidatePsi() {
        this.myQueue.cleanupStaleReferences();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            DebugUtil.onInvalidated(psi);
            psi.setSubstrateRef(SubstrateRef.createInvalidRef(psi));
        }
        this.myMap.clear();
    }

    void switchToStrongRefs() {
        this.myQueue.cleanupStaleReferences();
        for (MyReference reference : this.myMap.values()) {
            StubBasedPsiElementBase psi = (StubBasedPsiElementBase)SoftReference.dereference(reference);
            if (psi == null) continue;
            CompositeElement node = (CompositeElement)psi.getNode();
            node.setPsi(psi);
            psi.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
        }
        this.myMap.clear();
    }

    @Nullable
    StubBasedPsiElementBase<?> getCachedPsi(@NotNull AstPath ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/AstPathPsiMap", "getCachedPsi"));
        }
        return (StubBasedPsiElementBase)SoftReference.dereference((Reference)this.myMap.get(ref));
    }

    @NotNull
    StubBasedPsiElementBase<?> cachePsi(@NotNull AstPath key, @NotNull StubBasedPsiElementBase psi) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        this.myQueue.cleanupStaleReferences();
        psi.setSubstrateRef(key);
        this.myMap.put(key, new MyReference(psi, key, this.myQueue));
        StubBasedPsiElementBase stubBasedPsiElementBase = psi;
        if (stubBasedPsiElementBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/AstPathPsiMap", "cachePsi"));
        }
        return stubBasedPsiElementBase;
    }

    List<StubBasedPsiElementBase<?>> getAllCachedPsi() {
        this.myQueue.cleanupStaleReferences();
        if (this.myMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StubBasedPsiElementBase<?>> result2 = ContainerUtil.newArrayList();
        for (MyReference reference : this.myMap.values()) {
            ContainerUtil.addIfNotNull(result2, reference.get());
        }
        return result2;
    }

    private static class MyReferenceQueue
    extends ReferenceQueue<StubBasedPsiElementBase<?>> {
        MyReferenceQueue(Project project) {
            LowMemoryWatcher.register(() -> this.cleanupStaleReferences(), project);
        }

        void cleanupStaleReferences() {
            MyReference reference;
            while ((reference = (MyReference)this.poll()) != null) {
                AstPath key = reference.pathRef;
                key.getContainingFile().getRefToPsi().myMap.remove(key, reference);
            }
        }
    }

    private static class MyReference
    extends WeakReference<StubBasedPsiElementBase<?>> {
        final AstPath pathRef;

        MyReference(StubBasedPsiElementBase psi, AstPath ref, ReferenceQueue<StubBasedPsiElementBase<?>> queue) {
            super(psi, queue);
            this.pathRef = ref;
        }
    }
}

