/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.scala.serializers.ScalaPrimitiveTypeMapSerializer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;

public class ScalaCollectionDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaPrimitiveTypeMapSerializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaCollectionDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(JsonNode n) {
        return n.isArray();
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        ArrayList<Object> o = new ArrayList<Object>();
        try {
            logger.debug("using custom array deserializer");
            for (int i = 0; i < n.size(); ++i) {
                o.add(this.parent.deserialize(n.get(i), mapper));
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing Collection {}", (Object)e.getMessage());
            o = null;
        }
        if (o != null) {
            return JavaConversions.asScalaBuffer(o).toList();
        }
        return null;
    }
}

