/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.javash.evaluator;

import com.twosigma.beakerx.NamespaceClient;
import com.twosigma.beakerx.evaluator.BaseEvaluator;
import com.twosigma.beakerx.evaluator.JobDescriptor;
import com.twosigma.beakerx.evaluator.WorkerThread;
import com.twosigma.beakerx.javash.evaluator.Codev;
import com.twosigma.beakerx.javash.evaluator.CompilationException;
import com.twosigma.beakerx.javash.evaluator.JavaCodeRunner;
import com.twosigma.beakerx.javash.evaluator.JavaEvaluator;
import com.twosigma.beakerx.javash.evaluator.JavaSourceCompiler;
import com.twosigma.beakerx.javash.evaluator.ParserUtil;
import com.twosigma.beakerx.jvm.classloader.DynamicClassLoaderSimple;
import com.twosigma.beakerx.kernel.ImportPath;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.apache.commons.lang3.StringUtils;

class JavaWorkerThread
extends WorkerThread {
    private JavaEvaluator javaEvaluator;
    private boolean exit;
    private boolean updateLoader;

    public JavaWorkerThread(JavaEvaluator javaEvaluator) {
        super("javash worker");
        this.javaEvaluator = javaEvaluator;
        this.exit = false;
        this.updateLoader = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicClassLoaderSimple loader = null;
        JavaSourceCompiler javaSourceCompiler = new JavaSourceCompiler();
        NamespaceClient nc = null;
        while (!this.exit) {
            try {
                JobDescriptor j;
                this.syncObject.acquire();
                if (loader == null || this.updateLoader) {
                    loader = this.newClassLoader();
                    this.updateLoader = false;
                }
                if ((j = (JobDescriptor)this.jobQueue.poll()) == null) continue;
                nc = NamespaceClient.getBeaker((String)this.javaEvaluator.getSessionId());
                nc.setOutputObj(j.outputObject);
                this.runCode(loader, j, javaSourceCompiler);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (nc == null) continue;
                nc.setOutputObj(null);
                nc = null;
            }
        }
        NamespaceClient.delBeaker((String)this.javaEvaluator.getSessionId());
    }

    private void runCode(DynamicClassLoaderSimple loader, JobDescriptor j, org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler javaSourceCompiler) {
        j.outputObject.started();
        JavaSourceCompiler.CompilationUnit compilationUnit = javaSourceCompiler.createCompilationUnit(new File(this.javaEvaluator.getOutDir()));
        this.buildClasspath(compilationUnit);
        HashMap<Integer, Integer> lineNumbersMapping = new HashMap<Integer, Integer>();
        LineBrakingStringBuilderWrapper javaSourceCode = new LineBrakingStringBuilderWrapper();
        String code = ParserUtil.normalizeCode(j.codeToBeExecuted);
        Codev codev = new Codev(code);
        String pname = this.configurePackage(codev, lineNumbersMapping, javaSourceCode);
        this.configureImports(codev, lineNumbersMapping, javaSourceCode);
        this.compileCode(loader, j, javaSourceCompiler, pname, compilationUnit, codev, lineNumbersMapping, javaSourceCode);
    }

    private void compileCode(DynamicClassLoaderSimple loader, JobDescriptor j, org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler javaSourceCompiler, String pname, JavaSourceCompiler.CompilationUnit compilationUnit, Codev codev, Map<Integer, Integer> lineNumbersMapping, LineBrakingStringBuilderWrapper javaSourceCode) {
        if (codev.hasLineToProcess()) {
            Codev.CodeLine codeLine = codev.getNotBlankLine();
            Pattern p = Pattern.compile("(?:^|.*\\s+)(?:(?:class)|(?:interface))\\s+([a-zA-Z]\\w*).*");
            Matcher m = p.matcher(codeLine.getLine());
            if (m.matches()) {
                this.compileNewDefinitionClass(j, javaSourceCompiler, m, pname, compilationUnit, codev, lineNumbersMapping, javaSourceCode);
            } else {
                this.compileAndRunCode(loader, j, javaSourceCompiler, pname, compilationUnit, codev, lineNumbersMapping, javaSourceCode);
            }
        } else {
            this.compileAndRunCode(loader, j, javaSourceCompiler, pname, compilationUnit, codev, lineNumbersMapping, javaSourceCode);
        }
    }

    private void configureImports(Codev codev, Map<Integer, Integer> lineNumbersMapping, LineBrakingStringBuilderWrapper javaSourceCode) {
        if (codev.hasLineToProcess()) {
            Pattern p = Pattern.compile("\\s*import(\\s+static)?\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*(?:\\.\\*)?);.*");
            Codev.CodeLine codeLine = codev.getNotBlankLine();
            Matcher m = p.matcher(codeLine.getLine());
            while (m.matches()) {
                String impstr = m.group(2);
                String staticModifier = m.group(1);
                javaSourceCode.append("import ");
                if (staticModifier != null) {
                    javaSourceCode.append("static ");
                }
                javaSourceCode.append(impstr);
                javaSourceCode.append(";\n");
                lineNumbersMapping.put(javaSourceCode.getLinesCount(), codeLine.getIndex());
                codev.moveToNextLine();
                if (!codev.hasLineToProcess()) break;
                codeLine = codev.getNotBlankLine();
                m = p.matcher(codeLine.getLine());
            }
        }
    }

    private String configurePackage(Codev codev, Map<Integer, Integer> lineNumbersMapping, LineBrakingStringBuilderWrapper javaSourceCode) {
        String pname = this.javaEvaluator.getPackageId();
        Codev.CodeLine codeLine = codev.getNotBlankLine();
        Pattern p = Pattern.compile("\\s*package\\s+((?:[a-zA-Z]\\w*)(?:\\.[a-zA-Z]\\w*)*);.*");
        Matcher m = p.matcher(codeLine.getLine());
        if (m.matches()) {
            pname = m.group(1);
            lineNumbersMapping.put(1, codeLine.getIndex());
            codev.moveToNextLine();
        }
        javaSourceCode.append("package ");
        javaSourceCode.append(pname);
        javaSourceCode.append(";\n");
        for (ImportPath i : this.javaEvaluator.getImports().getImportPaths()) {
            javaSourceCode.append("import ");
            javaSourceCode.append(i.asString());
            javaSourceCode.append(";\n");
        }
        return pname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndRunCode(DynamicClassLoaderSimple loader, JobDescriptor j, org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler javaSourceCompiler, String pname, JavaSourceCompiler.CompilationUnit compilationUnit, Codev codev, Map<Integer, Integer> lineNumbersMapping, LineBrakingStringBuilderWrapper javaSourceCode) {
        String classId = this.generateClassId();
        String ret = "void";
        if (codev.getLastLine().matches("(^|.*\\s+)return\\s+.*")) {
            ret = "Object";
        }
        javaSourceCode.append("public class BeakerWrapperClass1261714175" + classId + " {\n");
        javaSourceCode.append("public static ");
        javaSourceCode.append(ret);
        javaSourceCode.append(" beakerRun() throws Exception {\n");
        this.addTheRestOfCode(codev, javaSourceCode, lineNumbersMapping);
        javaSourceCode.append("}\n");
        javaSourceCode.append("}\n");
        compilationUnit.addJavaSource(pname + "." + "BeakerWrapperClass1261714175" + classId, javaSourceCode.toString());
        try {
            javaSourceCompiler.compile(compilationUnit, new String[0]);
            javaSourceCompiler.persistCompiledClasses(compilationUnit);
            Class fooClass = loader.loadClass(pname + "." + "BeakerWrapperClass1261714175" + classId);
            Method mth = fooClass.getDeclaredMethod("beakerRun", null);
            if (!this.javaEvaluator.executeTask(new JavaCodeRunner(mth, j.outputObject, ret.equals("Object"), (ClassLoader)loader))) {
                j.outputObject.error((Object)BaseEvaluator.INTERUPTED_MSG);
            }
        }
        catch (CompilationException e) {
            j.outputObject.error((Object)this.buildErrorMessage(e, lineNumbersMapping));
        }
        catch (Exception e) {
            j.outputObject.error((Object)("ERROR: " + e.toString()));
        }
        finally {
            if (j.outputObject != null) {
                j.outputObject.executeCodeCallback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileNewDefinitionClass(JobDescriptor j, org.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler javaSourceCompiler, Matcher m, String pname, JavaSourceCompiler.CompilationUnit compilationUnit, Codev codev, Map<Integer, Integer> lineNumbersMapping, LineBrakingStringBuilderWrapper javaSourceCode) {
        String cname = m.group(1);
        this.addTheRestOfCode(codev, javaSourceCode, lineNumbersMapping);
        compilationUnit.addJavaSource(pname + "." + cname, javaSourceCode.toString());
        try {
            javaSourceCompiler.compile(compilationUnit, new String[0]);
            javaSourceCompiler.persistCompiledClasses(compilationUnit);
            j.outputObject.finished((Object)(pname + "." + cname));
        }
        catch (CompilationException e) {
            j.outputObject.error((Object)this.buildErrorMessage(e, lineNumbersMapping));
        }
        catch (Exception e) {
            j.outputObject.error((Object)("ERROR: " + e.toString()));
        }
        finally {
            if (j.outputObject != null) {
                j.outputObject.executeCodeCallback();
            }
        }
    }

    private DynamicClassLoaderSimple newClassLoader() {
        DynamicClassLoaderSimple loader = new DynamicClassLoaderSimple(ClassLoader.getSystemClassLoader());
        loader.addJars(this.javaEvaluator.getClasspath().getPathsAsStrings());
        loader.addDynamicDir(this.javaEvaluator.getOutDir());
        return loader;
    }

    private void buildClasspath(JavaSourceCompiler.CompilationUnit compilationUnit) {
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        if (classpathEntries != null && classpathEntries.length > 0) {
            compilationUnit.addClassPathEntries(Arrays.asList(classpathEntries));
        }
        if (!this.javaEvaluator.getClasspath().isEmpty()) {
            compilationUnit.addClassPathEntries(this.javaEvaluator.getClasspath().getPathsAsStrings());
        }
        compilationUnit.addClassPathEntry(this.javaEvaluator.getOutDir());
    }

    private String generateClassId() {
        return "Id" + UUID.randomUUID().toString().replace("-", "");
    }

    private String buildErrorMessage(CompilationException exception, Map<Integer, Integer> lineNumbersMapping) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ERROR: ").append(exception.getMessage()).append('\n');
        for (CompilationException.CompilationError compilationError : exception.getCompilationErrors()) {
            stringBuilder.append("error at line ").append(this.mapLineNumber(lineNumbersMapping, compilationError.getLineNumber())).append(": ").append(this.prepareForFrontend(compilationError.getErrorMessage())).append('\n').append(compilationError.getCode());
        }
        return stringBuilder.toString();
    }

    private String prepareForFrontend(String errorMessage) {
        return errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private Integer mapLineNumber(Map<Integer, Integer> lineNumbersMapping, int ourNumber) {
        Integer usersNumber = lineNumbersMapping.get(ourNumber);
        return usersNumber == null ? ourNumber : usersNumber + 1;
    }

    private void addTheRestOfCode(Codev codev, LineBrakingStringBuilderWrapper javaSourceCode, Map<Integer, Integer> lineNumbersMapping) {
        while (codev.hasLineToProcess()) {
            javaSourceCode.append(codev.getNotBlankLine().getLine());
            javaSourceCode.append("\n");
            lineNumbersMapping.put(javaSourceCode.getLinesCount(), codev.getNotBlankLine().getIndex());
            codev.moveToNextLine();
        }
    }

    public void updateLoader() {
        this.updateLoader = true;
    }

    public void doExit() {
        this.exit = true;
    }

    private static class LineBrakingStringBuilderWrapper {
        private static final String LINE_BREAK = "\n";
        private StringBuilder delegate = new StringBuilder();
        private int linesCount = 0;

        public void append(String string) {
            this.delegate.append(string);
            this.linesCount += StringUtils.countMatches((CharSequence)string, (CharSequence)LINE_BREAK);
        }

        public int getLinesCount() {
            return this.linesCount;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

